/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import it.zerono.mods.zerocore.lib.functional.ByteSupplier;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;

public class ByteData
implements IContainerData {
    private final ByteSupplier _getter;
    private final ByteConsumer _setter;
    private byte _lastValue;

    public ByteData(ByteSupplier getter, ByteConsumer setter) {
        this._getter = getter;
        this._setter = setter;
        this._lastValue = 0;
    }

    public static ByteData wrap(byte[] array, int index) {
        return new ByteData(() -> array[index], v -> {
            array[index] = v;
        });
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        byte current = this._getter.getAsByte();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeByte((int)this._getter.getAsByte());
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this._setter.accept(dataSource.readByte());
    }
}

