/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.cuboid;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.world.NeighboringPositions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractCuboidMultiblockController<Controller extends AbstractCuboidMultiblockController<Controller>>
extends AbstractMultiblockController<Controller> {
    private static final String[] s_errors = new String[5];

    @Override
    protected NeighboringPositions getNeighboringPositionsToVisit() {
        return new NeighboringPositions(CodeHelper.POSITIVE_DIRECTIONS);
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        int z;
        int y;
        int x;
        CuboidBoundingBox bb = this.getBoundingBox();
        if (this.getPartsCount() < this.getMinimumNumberOfPartsForAssembledMachine() || bb.isEmpty()) {
            validatorCallback.setLastError(ValidationError.VALIDATION_ERROR_TOO_FEW_PARTS);
            return false;
        }
        Level world = this.getWorld();
        BlockPos boundingBoxMin = bb.getMin();
        BlockPos boundingBoxMax = bb.getMax();
        int minX = boundingBoxMin.m_123341_();
        int minY = boundingBoxMin.m_123342_();
        int minZ = boundingBoxMin.m_123343_();
        int maxX = boundingBoxMax.m_123341_();
        int maxY = boundingBoxMax.m_123342_();
        int maxZ = boundingBoxMax.m_123343_();
        if (AbstractCuboidMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.X, this.getMinimumXSize(), this.getMaximumXSize(), maxX - minX + 1) || AbstractCuboidMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Y, this.getMinimumYSize(), this.getMaximumYSize(), maxY - minY + 1) || AbstractCuboidMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Z, this.getMinimumZSize(), this.getMaximumZSize(), maxZ - minZ + 1)) {
            return false;
        }
        if (null != this._detachedParts && !this._detachedParts.isEmpty()) {
            for (IMultiblockPart part : this._detachedParts) {
                boolean isValid;
                int errorIndex;
                BlockPos partLocation = part.getWorldPosition();
                x = partLocation.m_123341_();
                y = partLocation.m_123342_();
                z = partLocation.m_123343_();
                int extremes = 0;
                if (x == minX) {
                    ++extremes;
                }
                if (x == maxX) {
                    ++extremes;
                }
                if (y == minY) {
                    ++extremes;
                }
                if (y == maxY) {
                    ++extremes;
                }
                if (z == minZ) {
                    ++extremes;
                }
                if (z == maxZ) {
                    ++extremes;
                }
                if (extremes >= 2) {
                    errorIndex = 0;
                    isValid = this.isBlockGoodForFrame(world, x, y, z, validatorCallback);
                } else if (1 == extremes) {
                    if (y == maxY) {
                        errorIndex = 1;
                        isValid = this.isBlockGoodForTop(world, x, y, z, validatorCallback);
                    } else if (y == minY) {
                        errorIndex = 2;
                        isValid = this.isBlockGoodForBottom(world, x, y, z, validatorCallback);
                    } else {
                        errorIndex = 3;
                        isValid = this.isBlockGoodForSides(world, x, y, z, validatorCallback);
                    }
                } else {
                    errorIndex = 4;
                    isValid = this.isBlockGoodForInterior(world, x, y, z, validatorCallback);
                }
                if (isValid) continue;
                if (validatorCallback.isLastErrorEmpty()) {
                    validatorCallback.setLastError(partLocation, s_errors[errorIndex], new Object[0]);
                }
                return false;
            }
            this._detachedParts.clear();
        }
        BlockPos.MutableBlockPos partLocation = new BlockPos.MutableBlockPos();
        for (x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    boolean isValid;
                    int errorIndex;
                    partLocation.m_122178_(x, y, z);
                    IMultiblockPart<AbstractCuboidMultiblockController> part = this._connectedParts.get(BlockPos.m_121882_((int)x, (int)y, (int)z));
                    int extremes = 0;
                    boolean downFacing = false;
                    boolean upFacing = false;
                    boolean northFacing = false;
                    boolean southFacing = false;
                    boolean westFacing = false;
                    boolean eastFacing = false;
                    if (x == minX) {
                        ++extremes;
                        westFacing = true;
                    }
                    if (x == maxX) {
                        ++extremes;
                        eastFacing = true;
                    }
                    if (y == minY) {
                        ++extremes;
                        downFacing = true;
                    }
                    if (y == maxY) {
                        ++extremes;
                        upFacing = true;
                    }
                    if (z == minZ) {
                        ++extremes;
                        northFacing = true;
                    }
                    if (z == maxZ) {
                        ++extremes;
                        southFacing = true;
                    }
                    if (part instanceof AbstractCuboidMultiblockPart) {
                        PartPosition partPosition;
                        if (!part.testOnController(this::isControllerCompatible)) {
                            validatorCallback.setLastError((BlockPos)partLocation, "zerocore:api.multiblock.validation.invalid_part", new Object[0]);
                            return false;
                        }
                        if (extremes >= 2) {
                            errorIndex = 0;
                            partPosition = !eastFacing && !westFacing ? PartPosition.FrameEastWest : (!southFacing && !northFacing ? PartPosition.FrameSouthNorth : PartPosition.FrameUpDown);
                        } else if (1 == extremes) {
                            if (y == maxY) {
                                errorIndex = 1;
                                partPosition = PartPosition.TopFace;
                            } else if (y == minY) {
                                errorIndex = 2;
                                partPosition = PartPosition.BottomFace;
                            } else {
                                errorIndex = 3;
                                partPosition = eastFacing ? PartPosition.EastFace : (westFacing ? PartPosition.WestFace : (southFacing ? PartPosition.SouthFace : (northFacing ? PartPosition.NorthFace : (upFacing ? PartPosition.TopFace : PartPosition.BottomFace))));
                            }
                        } else {
                            errorIndex = 4;
                            partPosition = PartPosition.Interior;
                        }
                        BlockFacings facings = BlockFacings.from(downFacing, upFacing, northFacing, southFacing, westFacing, eastFacing);
                        ((AbstractCuboidMultiblockPart)part).setPartPosition(partPosition, facings);
                        isValid = ((AbstractCuboidMultiblockPart)part).isGoodForPosition(partPosition, validatorCallback);
                    } else if (extremes >= 2) {
                        errorIndex = 0;
                        isValid = this.isBlockGoodForFrame(world, x, y, z, validatorCallback);
                    } else if (1 == extremes) {
                        if (y == maxY) {
                            errorIndex = 1;
                            isValid = this.isBlockGoodForTop(world, x, y, z, validatorCallback);
                        } else if (y == minY) {
                            errorIndex = 2;
                            isValid = this.isBlockGoodForBottom(world, x, y, z, validatorCallback);
                        } else {
                            errorIndex = 3;
                            isValid = this.isBlockGoodForSides(world, x, y, z, validatorCallback);
                        }
                    } else {
                        errorIndex = 4;
                        isValid = this.isBlockGoodForInterior(world, x, y, z, validatorCallback);
                    }
                    if (isValid) continue;
                    if (validatorCallback.isLastErrorEmpty()) {
                        validatorCallback.setLastError((BlockPos)partLocation, s_errors[errorIndex], new Object[0]);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void forceStructureUpdate(Level world) {
        CuboidBoundingBox bb = this.getBoundingBox();
        if (bb.isEmpty()) {
            return;
        }
        BlockPos minCoord = bb.getMin();
        BlockPos maxCoord = bb.getMax();
        int minX = minCoord.m_123341_();
        int minY = minCoord.m_123342_();
        int minZ = minCoord.m_123343_();
        int maxX = maxCoord.m_123341_();
        int maxY = maxCoord.m_123342_();
        int maxZ = maxCoord.m_123343_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState state = world.m_8055_((BlockPos)pos.m_122178_(x, y, z));
                    world.m_7260_((BlockPos)pos, state, state, 3);
                }
            }
        }
    }

    protected AbstractCuboidMultiblockController(Level world) {
        super(world);
    }

    private static boolean isSizeWrong(IMultiblockValidator validatorCallback, Direction.Axis axis, int minSize, int maxSize, int size) {
        if (maxSize > 0 && size > maxSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_large", maxSize, axis.m_7912_());
            return true;
        }
        if (size < minSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_small", minSize, axis.m_7912_());
            return true;
        }
        return false;
    }

    static {
        AbstractCuboidMultiblockController.s_errors[0] = "zerocore:api.multiblock.validation.invalid_part_for_frame";
        AbstractCuboidMultiblockController.s_errors[1] = "zerocore:api.multiblock.validation.invalid_part_for_top";
        AbstractCuboidMultiblockController.s_errors[2] = "zerocore:api.multiblock.validation.invalid_part_for_bottom";
        AbstractCuboidMultiblockController.s_errors[3] = "zerocore:api.multiblock.validation.invalid_part_for_sides";
        AbstractCuboidMultiblockController.s_errors[4] = "zerocore:api.multiblock.validation.invalid_part_for_interior";
    }
}

