/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.cuboid;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractCuboidMultiblockPart<Controller extends AbstractCuboidMultiblockController<Controller>>
extends AbstractMultiblockPart<Controller> {
    private PartPosition _position = PartPosition.Unknown;
    private BlockFacings _outwardFacings = BlockFacings.NONE;

    public AbstractCuboidMultiblockPart(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    public abstract boolean isGoodForPosition(PartPosition var1, IMultiblockValidator var2);

    public BlockFacings getOutwardFacings() {
        return this._outwardFacings;
    }

    public PartPosition getPartPosition() {
        return this._position;
    }

    public Optional<Direction> getOutwardDirection() {
        return CodeHelper.optionalOr(this.getPartPosition().getDirection(), () -> {
            BlockFacings out = this.getOutwardFacings();
            return out.some() && 1 == out.countFacesIf(true) ? out.firstIf(true) : Optional.empty();
        });
    }

    public Optional<Direction> getOutwardFacingFromWorldPosition() {
        return this.evalOnController(controller -> {
            CuboidBoundingBox bb = controller.getBoundingBox();
            return AbstractCuboidMultiblockPart.getOutwardFacingFromWorldPositionInternal(this.getWorldPosition(), bb.getMin(), bb.getMax());
        }, Optional.empty());
    }

    public Direction getOutwardFacingFromWorldPosition(Direction defaultResult) {
        return this.evalOnController(controller -> {
            CuboidBoundingBox bb = controller.getBoundingBox();
            return AbstractCuboidMultiblockPart.getOutwardFacingFromWorldPositionInternal(this.getWorldPosition(), bb.getMin(), bb.getMax()).orElse(defaultResult);
        }, defaultResult);
    }

    private static Optional<Direction> getOutwardFacingFromWorldPositionInternal(BlockPos partPosition, BlockPos min, BlockPos max) {
        int x = partPosition.m_123341_();
        int y = partPosition.m_123342_();
        int z = partPosition.m_123343_();
        BlockFacings facings = BlockFacings.from(min.m_123342_() == y, max.m_123342_() == y, min.m_123343_() == z, max.m_123343_() == z, min.m_123341_() == x, max.m_123341_() == x);
        if (facings.some() && 1 == facings.countFacesIf(true)) {
            return facings.firstIf(true);
        }
        return Optional.empty();
    }

    void setPartPosition(PartPosition position, BlockFacings facings) {
        this._position = position;
        this._outwardFacings = facings;
    }

    public void notifyOutwardNeighborsOfStateChange() {
        Block blockType = this.getBlockType();
        BlockFacings facings = this.getOutwardFacings();
        BlockPos position = this.getWorldPosition();
        Level world = this.m_58904_();
        if (null != world) {
            for (Direction facing : CodeHelper.DIRECTIONS) {
                if (!facings.isSet(facing)) continue;
                WorldHelper.notifyNeighborsOfStateChange(world, position.m_142300_(facing), blockType);
            }
        }
    }

    @Override
    public void onPreMachineAssembled(Controller controller) {
    }

    @Override
    public void onPostMachineAssembled(Controller controller) {
    }

    @Override
    public void onPreMachineBroken() {
    }

    @Override
    public void onPostMachineBroken() {
        this._position = PartPosition.Unknown;
        this._outwardFacings = BlockFacings.NONE;
    }
}

