/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.rectangular;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.AbstractRectangularMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractRectangularMultiblockPart<Controller extends AbstractRectangularMultiblockController<Controller>>
extends AbstractMultiblockPart<Controller> {
    private PartPosition _position = PartPosition.Unknown;
    private BlockFacings _outwardFacings = BlockFacings.NONE;

    public AbstractRectangularMultiblockPart(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    public abstract boolean isGoodForPosition(PartPosition var1, IMultiblockValidator var2);

    public BlockFacings getOutwardFacings() {
        return this._outwardFacings;
    }

    public PartPosition getPartPosition() {
        return this._position;
    }

    public void notifyOutwardNeighborsOfStateChange() {
        Block blockType = this.getBlockType();
        BlockFacings facings = this.getOutwardFacings();
        BlockPos position = this.getWorldPosition();
        Level world = this.m_58904_();
        if (null != world) {
            for (Direction facing : CodeHelper.DIRECTIONS) {
                if (!facings.isSet(facing)) continue;
                WorldHelper.notifyNeighborsOfStateChange(world, position.m_142300_(facing), blockType);
            }
        }
    }

    @Override
    public void onAttached(Controller newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController);
    }

    @Override
    public void onPreMachineAssembled(Controller controller) {
        this.recalculateOutwardsDirection(controller);
    }

    @Override
    public void onPostMachineAssembled(Controller controller) {
    }

    @Override
    public void onPreMachineBroken() {
    }

    @Override
    public void onPostMachineBroken() {
        this._position = PartPosition.Unknown;
        this._outwardFacings = BlockFacings.NONE;
    }

    private void recalculateOutwardsDirection(Controller controller) {
        ((AbstractMultiblockController)controller).forBoundingBoxCoordinates((min, max) -> this.recalculateOutwardsDirection(controller, (BlockPos)min, (BlockPos)max));
    }

    private void recalculateOutwardsDirection(Controller controller, BlockPos min, BlockPos max) {
        BlockPos myPosition = this.getWorldPosition();
        boolean downFacing = myPosition.m_123342_() == min.m_123342_();
        boolean upFacing = myPosition.m_123342_() == max.m_123342_();
        boolean northFacing = myPosition.m_123343_() == min.m_123343_();
        boolean southFacing = myPosition.m_123343_() == max.m_123343_();
        boolean westFacing = myPosition.m_123341_() == min.m_123341_();
        boolean eastFacing = myPosition.m_123341_() == max.m_123341_();
        this._outwardFacings = BlockFacings.from(downFacing, upFacing, northFacing, southFacing, westFacing, eastFacing);
        this._position = PartPosition.positionIn(controller, myPosition);
    }
}

