/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.result;

import com.google.gson.JsonElement;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackRecipeResult
implements IRecipeResult<FluidStack> {
    private final FluidStack _result;

    public static FluidStackRecipeResult from(FluidStack stack) {
        return new FluidStackRecipeResult(stack);
    }

    public static FluidStackRecipeResult from(FriendlyByteBuf buffer) {
        return new FluidStackRecipeResult(FluidStack.readFromPacket((FriendlyByteBuf)buffer));
    }

    public static FluidStackRecipeResult from(JsonElement jsonElement) {
        return new FluidStackRecipeResult(FluidHelper.stackFrom(jsonElement));
    }

    @Override
    public ResourceLocation getId() {
        return Objects.requireNonNull(this._result.getFluid().getRegistryName());
    }

    @Override
    public FluidStack getResult() {
        return this._result.copy();
    }

    @Override
    public long getAmount() {
        return this._result.isEmpty() ? 0L : (long)this._result.getAmount();
    }

    @Override
    public boolean isEmpty() {
        return this._result.isEmpty();
    }

    @Override
    public void serializeTo(FriendlyByteBuf buffer) {
        this._result.writeToPacket(buffer);
    }

    @Override
    public JsonElement serializeTo() {
        return FluidHelper.stackToJSON(this._result);
    }

    public String toString() {
        return FluidHelper.toStringHelper(this._result);
    }

    private FluidStackRecipeResult(FluidStack stack) {
        this._result = stack;
    }
}

