/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.PacketExecutor;
import mcp.mobius.waila.network.PacketIo;
import mcp.mobius.waila.network.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgePacketSender
extends PacketSender {
    static final String PROTOCOL = "2";
    static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)Waila.id("networking"), () -> "2", (Predicate)NetworkRegistry.acceptMissingOr((String)"2"), (Predicate)NetworkRegistry.acceptMissingOr((String)"2"));

    @Override
    public void initMain() {
        int i = 0;
        NETWORK.registerMessage(i++, ReceiveData.class, (msg, buf) -> PacketIo.ReceiveData.write((FriendlyByteBuf)buf, msg.tag), buf -> PacketIo.ReceiveData.apply((FriendlyByteBuf)buf, ReceiveData::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PacketExecutor.receiveData(msg.tag));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, GenerateClientDump.class, (msg, buf) -> PacketIo.GenerateClientDump.write((FriendlyByteBuf)buf, (Void)null), buf -> PacketIo.GenerateClientDump.apply((FriendlyByteBuf)buf, unused -> new GenerateClientDump()), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(PacketExecutor::generateClientDump);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, SendConfig.class, (msg, buf) -> PacketIo.SendConfig.write((FriendlyByteBuf)buf, msg.config), buf -> PacketIo.SendConfig.apply((FriendlyByteBuf)buf, SendConfig::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PacketExecutor.sendConfig(msg.forcedKeys));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, RequestEntity.class, (msg, buf) -> PacketIo.RequestEntity.write((FriendlyByteBuf)buf, msg.hitResult), buf -> PacketIo.RequestEntity.apply((FriendlyByteBuf)buf, RequestEntity::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgePacketSender.lambda$initMain$17((Supplier)ctx, msg));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, RequestBlock.class, (msg, buf) -> PacketIo.RequestBlock.write((FriendlyByteBuf)buf, msg.hitResult), buf -> PacketIo.RequestBlock.apply((FriendlyByteBuf)buf, RequestBlock::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgePacketSender.lambda$initMain$23((Supplier)ctx, msg));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NETWORK.registerMessage(i++, SendBlacklist.class, (msg, buf) -> PacketIo.SendBlacklist.write((FriendlyByteBuf)buf, msg.config), buf -> PacketIo.SendBlacklist.apply((FriendlyByteBuf)buf, SendBlacklist::new), (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PacketExecutor.sendBlacklist(msg.ids));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    @Override
    public void sendPluginConfig(PluginConfig config, ServerPlayer player) {
        NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendConfig(config));
    }

    @Override
    public void sendBlacklistConfig(BlacklistConfig config, ServerPlayer player) {
        NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendBlacklist(config));
    }

    @Override
    public void generateClientDump(ServerPlayer player) {
        NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GenerateClientDump());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isServerAvailable() {
        return NETWORK.isRemotePresent(Minecraft.m_91087_().m_91403_().m_6198_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void requestEntity(EntityHitResult hitResult) {
        NETWORK.sendToServer((Object)new RequestEntity(hitResult));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void requestBlock(BlockHitResult hitResult) {
        NETWORK.sendToServer((Object)new RequestBlock(hitResult));
    }

    private static /* synthetic */ void lambda$initMain$23(Supplier ctx, RequestBlock msg) {
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        PacketExecutor.requestBlockEntity(player, msg.hitResult, tag -> NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ReceiveData((CompoundTag)tag)));
    }

    private static /* synthetic */ void lambda$initMain$17(Supplier ctx, RequestEntity msg) {
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        PacketExecutor.requestEntity(player, msg.id2vec, tag -> NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ReceiveData((CompoundTag)tag)));
    }

    public static class ReceiveData {
        public CompoundTag tag;

        public ReceiveData(CompoundTag tag) {
            this.tag = tag;
        }
    }

    public static class GenerateClientDump {
    }

    public static class SendConfig {
        Map<ResourceLocation, Object> forcedKeys;
        PluginConfig config;

        SendConfig(@Nullable Map<ResourceLocation, Object> forcedKeys) {
            this.forcedKeys = forcedKeys;
        }

        SendConfig(PluginConfig config) {
            this.config = config;
        }
    }

    public static class RequestEntity {
        IntObjectPair<Vec3> id2vec;
        EntityHitResult hitResult;

        RequestEntity(EntityHitResult hitResult) {
            this.hitResult = hitResult;
        }

        RequestEntity(IntObjectPair<Vec3> id2vec) {
            this.id2vec = id2vec;
        }
    }

    public static class RequestBlock {
        BlockHitResult hitResult;

        RequestBlock(BlockHitResult hitResult) {
            this.hitResult = hitResult;
        }
    }

    public static class SendBlacklist {
        BlacklistConfig config;
        int[][] ids;

        SendBlacklist(BlacklistConfig config) {
            this.config = config;
        }

        SendBlacklist(int[][] ids) {
            this.ids = ids;
        }
    }
}

