/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T>
extends ConfigListWidget.Entry {
    protected final Consumer<T> save;
    protected final String translationKey;
    @Nullable
    protected final T defaultValue;
    private final Component title;
    private final String description;
    private final Button resetButton;
    private T value;
    private int x;

    public ConfigValue(String translationKey, T value, @Nullable T defaultValue, Consumer<T> save) {
        this.translationKey = translationKey;
        this.title = new TranslatableComponent(translationKey);
        this.description = translationKey + "_desc";
        this.value = value;
        this.save = save;
        this.defaultValue = defaultValue;
        this.resetButton = defaultValue == null ? null : new Button(0, 0, 40, 20, (Component)new TranslatableComponent("controls.reset"), button -> this.resetValue());
    }

    @Override
    public final void m_6311_(PoseStack matrices, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        super.m_6311_(matrices, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        Font font = this.client.f_91062_;
        String string = this.title.getString();
        float f = rowLeft;
        float f2 = rowTop;
        Objects.requireNonNull(this.client.f_91062_);
        font.m_92750_(matrices, string, f, f2 + (float)(height - 9) / 2.0f, 0xFFFFFF);
        int w = width;
        if (this.resetButton != null) {
            w -= this.resetButton.m_5711_() + 2;
            this.resetButton.f_93620_ = rowLeft + width - this.resetButton.m_5711_();
            this.resetButton.f_93621_ = rowTop + (height - this.resetButton.m_93694_()) / 2;
            this.resetButton.f_93623_ = !this.getValue().equals(this.defaultValue);
            this.resetButton.m_6305_(matrices, mouseX, mouseY, deltaTime);
        }
        this.drawValue(matrices, w, height, rowLeft, rowTop, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void save() {
        this.save.accept(this.getValue());
    }

    public GuiEventListener getListener() {
        return null;
    }

    @Nullable
    public Button getResetButton() {
        return this.resetButton;
    }

    public Component getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getX() {
        return this.x;
    }

    public final T getValue() {
        return this.value;
    }

    public final void setValue(T value) {
        this.value = value;
    }

    protected void resetValue() {
        this.setValue(this.defaultValue);
    }

    protected abstract void drawValue(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);
}

