/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.gson.Gson;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.access.ServerAccessor;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PacketExecutor {
    private static final Gson GSON = new Gson();

    public static void generateClientDump() {
        Path path = Waila.GAME_DIR.resolve(".waila/WailaClientDump.md");
        if (DumpGenerator.generate(path)) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("command.waila.client_dump_success", new Object[]{path}), false);
        }
    }

    public static void receiveData(CompoundTag tag) {
        DataAccessor.INSTANCE.setServerData(tag);
    }

    public static void sendConfig(Map<ResourceLocation, Object> map) {
        for (ConfigEntry<Object> config : PluginConfig.INSTANCE.getSyncableConfigs()) {
            Object object;
            ResourceLocation id = config.getId();
            Object defaultValue = config.getDefaultValue();
            if (defaultValue instanceof Enum) {
                Enum e = (Enum)defaultValue;
                object = Enum.valueOf(e.getDeclaringClass(), (String)map.getOrDefault(id, e.name()));
            } else {
                object = map.getOrDefault(id, defaultValue);
            }
            Object syncedValue = object;
            config.setValue(syncedValue);
        }
        Waila.LOGGER.info("Received config from the server: {}", (Object)GSON.toJson(map));
    }

    public static void sendBlacklist(int[][] rawIds) {
        BlacklistConfig blacklist = Waila.BLACKLIST_CONFIG.get();
        PacketExecutor.setBlackList(rawIds[0], blacklist.blocks, Registry.f_122824_);
        PacketExecutor.setBlackList(rawIds[1], blacklist.blockEntityTypes, Registry.f_122830_);
        PacketExecutor.setBlackList(rawIds[2], blacklist.entityTypes, Registry.f_122826_);
    }

    public static void requestEntity(ServerPlayer player, IntObjectPair<Vec3> pair, Consumer<CompoundTag> consumer) {
        Registrar registrar = Registrar.INSTANCE;
        Level world = player.f_19853_;
        Entity entity = world.m_6815_(pair.leftInt());
        if (entity == null) {
            return;
        }
        CompoundTag data = new CompoundTag();
        IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)new EntityHitResult(entity, (Vec3)pair.right()), entity);
        for (IServerDataProvider<Entity> provider : registrar.entityData.get(entity)) {
            provider.appendServerData(data, accessor, PluginConfig.INSTANCE);
            provider.appendServerData(data, player, world, entity);
        }
        data.m_128405_("WailaEntityID", entity.m_142049_());
        consumer.accept(data);
    }

    public static void requestBlockEntity(ServerPlayer player, BlockHitResult hitResult, Consumer<CompoundTag> consumer) {
        Registrar registrar = Registrar.INSTANCE;
        Level world = player.f_19853_;
        BlockPos pos = hitResult.m_82425_();
        if (!world.m_46805_(pos)) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        CompoundTag data = new CompoundTag();
        IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)hitResult, blockEntity);
        for (IServerDataProvider<BlockEntity> provider : registrar.blockData.get(blockEntity)) {
            provider.appendServerData(data, accessor, PluginConfig.INSTANCE);
            provider.appendServerData(data, player, world, blockEntity);
        }
        for (IServerDataProvider<BlockEntity> provider : registrar.blockData.get(state.m_60734_())) {
            provider.appendServerData(data, accessor, PluginConfig.INSTANCE);
            provider.appendServerData(data, player, world, blockEntity);
        }
        data.m_128405_("x", pos.m_123341_());
        data.m_128405_("y", pos.m_123342_());
        data.m_128405_("z", pos.m_123343_());
        data.m_128359_("id", Registry.f_122830_.m_7981_((Object)blockEntity.m_58903_()).toString());
        consumer.accept(data);
    }

    private static <T> void setBlackList(int[] ids, Set<T> set, Registry<T> registry) {
        for (int id : ids) {
            set.add(registry.m_7942_(id));
        }
    }
}

