/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.extremereactors.api.reactor.Reaction;
import it.zerono.mods.extremereactors.api.reactor.ReactionsRegistry;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterial;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterialRegistry;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public final class ExtremeReactorsCommand {
    private static final String PARAM_NAME = "name";
    private static final String PARAM_TAG = "tag";
    private static final String PARAM_VALUE = "value";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"er").requires(cs -> cs.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reactants").then(Commands.m_82127_((String)"get").then(ExtremeReactorsCommand.nameParam().executes(ExtremeReactorsCommand::getReactant)))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)ExtremeReactorsCommand.nameParam().then(ExtremeReactorsCommand.stringCommand("colour", (Command<CommandSourceStack>)((Command)ExtremeReactorsCommand::setReactantColour)))).then(ExtremeReactorsCommand.floatCommand("moderation", 0.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSourceStack>)context, r -> Float.valueOf(r.getFuelData().getModerationFactor()), (r, v) -> r.getFuelData().setModerationFactor(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("absorption", 0.0f, 1.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSourceStack>)context, r -> Float.valueOf(r.getFuelData().getAbsorptionCoefficient()), (r, v) -> r.getFuelData().setAbsorptionCoefficient(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("hardness", 1.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSourceStack>)context, r -> Float.valueOf(r.getFuelData().getHardnessDivisor()), (r, v) -> r.getFuelData().setHardnessDivisor(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("fissionevents", 0.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSourceStack>)context, r -> Float.valueOf(r.getFuelData().getFissionEventsPerFuelUnit()), (r, v) -> r.getFuelData().setFissionEventsPerFuelUnit(v.floatValue())))))).then(ExtremeReactorsCommand.floatCommand("fuelunits", 0.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setReactantFuelValue((CommandContext<CommandSourceStack>)context, r -> Float.valueOf(r.getFuelData().getFuelUnitsPerFissionEvent()), (r, v) -> r.getFuelData().setFuelUnitsPerFissionEvent(v.floatValue()))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reaction").then(Commands.m_82127_((String)"get").then(ExtremeReactorsCommand.nameParam().executes(ExtremeReactorsCommand::getReaction)))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)ExtremeReactorsCommand.nameParam().then(ExtremeReactorsCommand.floatCommand("reactivity", 1.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setReactionValue((CommandContext<CommandSourceStack>)context, "_reactivity", ExtremeReactorsCommand.getFloat((CommandContext<CommandSourceStack>)context)))))).then(ExtremeReactorsCommand.floatCommand("fissionRate", 1.0E-4f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setReactionValue((CommandContext<CommandSourceStack>)context, "_fissionRate", ExtremeReactorsCommand.getFloat((CommandContext<CommandSourceStack>)context))))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"coils").then(Commands.m_82127_((String)"get").then(ExtremeReactorsCommand.tagIdParam().executes(ExtremeReactorsCommand::getCoil)))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ExtremeReactorsCommand.tagIdParam().then(ExtremeReactorsCommand.floatCommand("efficiency", 0.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setCoilValue((CommandContext<CommandSourceStack>)context, CoilMaterial::getEfficiency, CoilMaterial::setEfficiency))))).then(ExtremeReactorsCommand.floatCommand("bonus", 0.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setCoilValue((CommandContext<CommandSourceStack>)context, CoilMaterial::getBonus, CoilMaterial::setBonus))))).then(ExtremeReactorsCommand.floatCommand("energyExtractionRate", 0.0f, (Command<CommandSourceStack>)((Command)context -> ExtremeReactorsCommand.setCoilValue((CommandContext<CommandSourceStack>)context, CoilMaterial::getEnergyExtractionRate, CoilMaterial::setEnergyExtractionRate))))))));
    }

    private ExtremeReactorsCommand() {
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> stringCommand(String propertyName, Command<CommandSourceStack> cmd) {
        return Commands.m_82127_((String)propertyName).then(Commands.m_82129_((String)PARAM_VALUE, (ArgumentType)StringArgumentType.string()).executes(cmd));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> floatCommand(String propertyName, float min, Command<CommandSourceStack> cmd) {
        return Commands.m_82127_((String)propertyName).then(Commands.m_82129_((String)PARAM_VALUE, (ArgumentType)FloatArgumentType.floatArg((float)min)).executes(cmd));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> floatCommand(String propertyName, float min, float max, Command<CommandSourceStack> cmd) {
        return Commands.m_82127_((String)propertyName).then(Commands.m_82129_((String)PARAM_VALUE, (ArgumentType)FloatArgumentType.floatArg((float)min, (float)max)).executes(cmd));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> nameParam() {
        return Commands.m_82129_((String)PARAM_NAME, (ArgumentType)StringArgumentType.string());
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> tagIdParam() {
        return Commands.m_82129_((String)PARAM_TAG, (ArgumentType)ResourceLocationArgument.m_106984_());
    }

    private static String getName(CommandContext<CommandSourceStack> context) {
        return StringArgumentType.getString(context, (String)PARAM_NAME);
    }

    private static ResourceLocation getTagId(CommandContext<CommandSourceStack> context) {
        return ResourceLocationArgument.m_107011_(context, (String)PARAM_TAG);
    }

    private static String getString(CommandContext<CommandSourceStack> context) {
        return StringArgumentType.getString(context, (String)PARAM_VALUE);
    }

    private static float getFloat(CommandContext<CommandSourceStack> context) {
        return FloatArgumentType.getFloat(context, (String)PARAM_VALUE);
    }

    private static int getReactant(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).map(ExtremeReactorsCommand::getTextFrom).orElse((Component)new TextComponent("Reactant not found")), true);
        return 0;
    }

    private static int setReactantColour(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).map(r -> ExtremeReactorsCommand.setReactantColour(r, (int)Long.parseLong(ExtremeReactorsCommand.getString(context), 16))).orElse((Component)new TextComponent("Reactant not found")), true);
        return 0;
    }

    private static Component setReactantColour(Reactant reactant, int colour) {
        try {
            Field f = reactant.getClass().getDeclaredField("_colour");
            f.setAccessible(true);
            f.set(reactant, Colour.fromRGBA((int)colour));
            return new TextComponent(String.format("Reactant %s colour set to 0x%08X", reactant.getName(), colour));
        }
        catch (Exception ex) {
            Log.LOGGER.error((Object)ex);
            return new TextComponent("Exception raised while setting colour field");
        }
    }

    private static int setReactantFuelValue(CommandContext<CommandSourceStack> context, Function<Reactant, Float> getter, BiConsumer<Reactant, Float> setter) {
        ((CommandSourceStack)context.getSource()).m_81354_(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).filter(r -> r.test(ReactantType.Fuel)).map(r -> ExtremeReactorsCommand.setValue(r, ExtremeReactorsCommand.getFloat(context), getter, setter)).orElse((Component)new TextComponent("Fuel Reactant not found")), true);
        return 0;
    }

    private static Component getTextFrom(Reactant reactant) {
        TextComponent text = new TextComponent(String.format("[" + ChatFormatting.BOLD + "%s" + ChatFormatting.RESET + "] " + ChatFormatting.GOLD + "%s; " + ChatFormatting.RESET + ChatFormatting.ITALIC + "color: " + ChatFormatting.RESET + "%08X", new Object[]{reactant.getType(), reactant.getName(), reactant.getColour().toRGBA()}));
        if (reactant.test(ReactantType.Fuel)) {
            FuelProperties properties = reactant.getFuelData();
            text.m_7220_((Component)new TextComponent(String.format("; " + ChatFormatting.ITALIC + "moderation: " + ChatFormatting.RESET + "%f; " + ChatFormatting.ITALIC + "absorption: " + ChatFormatting.RESET + "%f; " + ChatFormatting.ITALIC + "hardness: " + ChatFormatting.RESET + "%f; " + ChatFormatting.ITALIC + "fissionEventsPerFuelUnit: " + ChatFormatting.RESET + "%f; " + ChatFormatting.ITALIC + "fuelUnitsPerFissionEvent: " + ChatFormatting.RESET + "%f", Float.valueOf(properties.getModerationFactor()), Float.valueOf(properties.getAbsorptionCoefficient()), Float.valueOf(properties.getHardnessDivisor()), Float.valueOf(properties.getFissionEventsPerFuelUnit()), Float.valueOf(properties.getFuelUnitsPerFissionEvent()))));
        }
        return text;
    }

    private static int getReaction(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).flatMap(ReactionsRegistry::get).map(ExtremeReactorsCommand::getTextFrom).orElse((Component)new TextComponent("Reactant or reaction not found")), true);
        return 0;
    }

    private static Component getTextFrom(Reaction reaction) {
        return new TextComponent(String.format("[" + ChatFormatting.BOLD + "%s" + ChatFormatting.RESET + " -> " + ChatFormatting.BOLD + "%s" + ChatFormatting.RESET + "] " + ChatFormatting.ITALIC + "reactivity: " + ChatFormatting.RESET + "%f; " + ChatFormatting.ITALIC + "fissionRate: " + ChatFormatting.RESET + "%f", reaction.getSource(), reaction.getProduct(), Float.valueOf(reaction.getReactivity()), Float.valueOf(reaction.getFissionRate())));
    }

    private static int setReactionValue(CommandContext<CommandSourceStack> context, String fieldName, float value) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)ReactantsRegistry.get(ExtremeReactorsCommand.getName(context)).flatMap(ReactionsRegistry::get).map(reaction -> {
            try {
                Field f = reaction.getClass().getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(reaction, Float.valueOf(value));
                return new TextComponent(String.format("Reaction %s parameter %s set to %f", reaction.getSource(), fieldName, Float.valueOf(value)));
            }
            catch (Exception ex) {
                Log.LOGGER.error((Object)ex);
                return new TextComponent(String.format("Exception raised while setting Reaction field %s", fieldName));
            }
        }).orElse(new TextComponent("Reactant or reaction not found")), true);
        return 0;
    }

    private static int getCoil(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(ExtremeReactorsCommand.getCoilByName(context).map(ExtremeReactorsCommand::getTextFrom).orElse((Component)new TextComponent("Coil not found")), true);
        return 0;
    }

    private static int setCoilValue(CommandContext<CommandSourceStack> context, Function<CoilMaterial, Float> getter, BiConsumer<CoilMaterial, Float> setter) {
        ((CommandSourceStack)context.getSource()).m_81354_(ExtremeReactorsCommand.getCoilByName(context).map(c -> ExtremeReactorsCommand.setValue(c, ExtremeReactorsCommand.getFloat(context), getter, setter)).orElse((Component)new TextComponent("Coil not found")), true);
        return 0;
    }

    private static Component getTextFrom(CoilMaterial coil) {
        return new TextComponent(String.format(ChatFormatting.ITALIC + "efficiency: " + ChatFormatting.RESET + "%f; " + ChatFormatting.ITALIC + "bonus: " + ChatFormatting.RESET + "%f; " + ChatFormatting.ITALIC + "energyExtractionRate: " + ChatFormatting.RESET + "%f", Float.valueOf(coil.getEfficiency()), Float.valueOf(coil.getBonus()), Float.valueOf(coil.getEnergyExtractionRate())));
    }

    private static Optional<CoilMaterial> getCoilByName(CommandContext<CommandSourceStack> context) {
        return CoilMaterialRegistry.get((TagKey<Block>)TagsHelper.BLOCKS.createKey(ExtremeReactorsCommand.getTagId(context)));
    }

    private static <T> Component setValue(T coil, float value, Function<T, Float> getter, BiConsumer<T, Float> setter) {
        setter.accept(coil, Float.valueOf(value));
        return new TextComponent(String.format("Value set to %f", getter.apply(coil)));
    }
}

