/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container.FluidizerControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerFluidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.base.client.screen.control.EnergyBar;
import it.zerono.mods.zerocore.base.client.screen.control.FluidBar;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.base.client.screen.control.OnOff;
import it.zerono.mods.zerocore.base.multiblock.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.PanelGroup;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.TabularLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;

public class FluidizerControllerScreen
extends AbstractMultiblockScreen<MultiblockFluidizer, FluidizerControllerEntity, FluidizerControllerContainer> {
    private static final int VBARPANEL_HEIGHT = 84;
    private final EnergyBar _energyBar = new EnergyBar((ModContainerScreen)this, "energyBar", EnergySystem.ForgeEnergy, MultiblockFluidizer.ENERGY_CAPACITY, container::getEnergyStored, null);
    private final RecipePanel _recipePanel = new RecipePanel();
    private final MachineStatusIndicator _indicator = new MachineStatusIndicator((ModContainerScreen)this, "indicator");

    public FluidizerControllerScreen(FluidizerControllerContainer container, Inventory inventory, Component title) {
        super((ModTileContainer)container, inventory, PlayerInventoryUsage.None, title, FluidizerIcons::getMap);
        this._indicator.setTooltips(true, "gui.bigreactors.fluidizer.active");
        this._indicator.setTooltips(false, "gui.bigreactors.fluidizer.inactive");
    }

    public boolean m_6913_() {
        return true;
    }

    @Nullable
    protected IControl getTitleBarWidget() {
        return this._indicator;
    }

    public int getTooltipsPopupMaxWidth() {
        return FluidizerControllerScreen.parseTooltipsPopupMaxWidthFromLang((String)"gui.bigreactors.fluidizer.controller.tooltips_popup_max_width", (int)150);
    }

    protected void onScreenCreate() {
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, ExtremeReactors.newID("fluidizer/part-controller"), 1);
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setVerticalMargin(1)).setHorizontalMargin(13)).setControlsSpacing(0));
        Panel mainPanel = new Panel((ModContainerScreen)this);
        mainPanel.setDesiredDimension(DesiredDimension.Height, 84);
        mainPanel.setLayoutEngine((ILayoutEngine)TabularLayoutEngine.builder().columns(5, new int[]{18, 11, 108, 11, 50}).rows(1).build());
        this.addControl((IControl)mainPanel);
        mainPanel.addControl((IControl)this._energyBar);
        mainPanel.addControl((IControl)this.vSeparatorPanel());
        mainPanel.addControl((IControl)this._recipePanel);
        mainPanel.addControl((IControl)this.vSeparatorPanel());
        Panel commandPanel = this.vCommandPanel();
        mainPanel.addControl((IControl)commandPanel);
        Supplier<Boolean> isActive = ((FluidizerControllerContainer)this.m_6262_())::isFluidizerActive;
        OnOff onOff = new OnOff((ModContainerScreen)this, isActive, this::onActiveStateChanged, (Component)new TranslatableComponent("gui.bigreactors.fluidizer.controller.on.line1"), (Component)new TranslatableComponent("gui.bigreactors.fluidizer.controller.off.line1"));
        onOff.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)50, (int)16));
        commandPanel.addControl((IControl)onOff);
        this.addDataBinding(isActive, (Consumer)this._indicator);
    }

    private void onActiveStateChanged(SwitchButton button) {
        if (!this.isDataUpdateInProgress()) {
            this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
        }
    }

    private Panel vSeparatorPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        Static s = new Static((ModContainerScreen)this, 1, 84);
        p.setDesiredDimension(11, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        s.setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)5, (int)0, (int)1, (int)84));
        p.addControl((IControl)s);
        return p;
    }

    private Panel vCommandPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(DesiredDimension.Height, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        return p;
    }

    private class RecipePanel
    extends PanelGroup<IFluidizerRecipe.Type> {
        private final FluidBar _outputFluidBar;
        private final Static[] _solidIngredients;
        private final FluidBar[] _fluidIngredients;
        private final GaugeBar _leftProgressBar;
        private final GaugeBar _rightProgressBar;

        public RecipePanel() {
            super((ModContainerScreen)FluidizerControllerScreen.this, "recipes", (Enum[])IFluidizerRecipe.Type.values());
            this.setDesiredDimension(108, 84);
            FluidizerControllerContainer container = (FluidizerControllerContainer)FluidizerControllerScreen.this.m_6262_();
            FluidizerControllerScreen.this.addDataBinding(container::getRecipeType, arg_0 -> ((RecipePanel)this).setActivePanel(arg_0));
            FluidizerControllerScreen.this.addDataBinding(container::getRecipeProgress, this::setProgress);
            this._outputFluidBar = new FluidBar((ModContainerScreen)FluidizerControllerScreen.this, "outbar", (double)container.getOutputCapacity(), () -> container.getOutputAmount(), container::getOutput, (NonNullSupplier)BaseIcons.Bucket, "gui.bigreactors.fluidizer.controller.fluidbar.line1", null);
            this._leftProgressBar = this.progressBar(true, FluidizerIcons.ProgressLeft, FluidizerIcons.ProgressLeftFilled);
            this._rightProgressBar = this.progressBar(false, FluidizerIcons.ProgressRight, FluidizerIcons.ProgressRightFilled);
            this._solidIngredients = new Static[2];
            Arrays.setAll(this._solidIngredients, i -> this.solidSlot());
            int i2 = 0;
            while (i2 < 2) {
                int index = i2++;
                this._solidIngredients[index] = this.solidSlot();
                FluidizerControllerScreen.this.addDataBinding(() -> container.getSolidInput(index), stack -> this.setInput(index, (ItemStack)stack));
            }
            this._fluidIngredients = new FluidBar[2];
            Arrays.setAll(this._fluidIngredients, i -> new FluidBar((ModContainerScreen)FluidizerControllerScreen.this, "inputfluid" + i, (double)FluidizerFluidInjectorEntity.MAX_CAPACITY, () -> container.getFluidInputAmount(i), () -> container.getFluidInput(i), Sprite.EMPTY_SUPPLIER, "gui.bigreactors.fluidizer.controller.inputfuel.title", null));
            this.setPanel(IFluidizerRecipe.Type.Invalid, this.noRecipePanel());
            this.setPanel(IFluidizerRecipe.Type.Solid, this.solidRecipePanel());
            this.setPanel(IFluidizerRecipe.Type.SolidMixing, this.solidMixingRecipePanel());
            this.setPanel(IFluidizerRecipe.Type.FluidMixing, this.fluidMixingRecipePanel());
            this.setActivePanel(IFluidizerRecipe.Type.Invalid);
        }

        public void setProgress(double progress) {
            this._leftProgressBar.setValue(progress);
            this._rightProgressBar.setValue(progress);
        }

        public void setInput(int index, ItemStack stack) {
            this._solidIngredients[index].setStackAsInventory(stack);
        }

        private GaugeBar progressBar(boolean left, NonNullSupplier<ISprite> background, NonNullSupplier<ISprite> filler) {
            GaugeBar bar = new GaugeBar((ModContainerScreen)FluidizerControllerScreen.this, left ? "sxprogress" : "dxprogress", 1.0, (ISprite)filler.get());
            bar.setDesiredDimension(24, 16);
            bar.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)TabularLayoutEngine.hintBuilder().setPadding(Padding.get((int)0, (int)0, (int)18, (int)0)).build());
            bar.setBackground((ISprite)background.get());
            bar.setOrientation(left ? Orientation.LeftToRight : Orientation.RightToLeft);
            return bar;
        }

        private Static solidSlot() {
            Static s = new Static((ModContainerScreen)FluidizerControllerScreen.this, 18, 18);
            s.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)TabularLayoutEngine.hintBuilder().setPadding(Padding.get((int)0, (int)0, (int)18, (int)0)).build());
            s.setPadding(1);
            return s;
        }

        private Panel panel() {
            Panel p = new Panel((ModContainerScreen)FluidizerControllerScreen.this);
            p.setDesiredDimension(108, 84);
            p.setLayoutEngine((ILayoutEngine)TabularLayoutEngine.builder().columns(5, new int[]{18, 27, 18, 27, 18}).rows(1).build());
            return p;
        }

        private Panel noRecipePanel() {
            Panel p = this.panel();
            Static dummy = new Static((ModContainerScreen)FluidizerControllerScreen.this, 1, 1);
            p.addControl(new IControl[]{dummy, dummy, this._outputFluidBar});
            return p;
        }

        private Panel solidRecipePanel() {
            Panel p = this.panel();
            p.addControl(new IControl[]{this._solidIngredients[0], this._leftProgressBar, this._outputFluidBar});
            return p;
        }

        private Panel solidMixingRecipePanel() {
            Panel p = this.panel();
            p.addControl(new IControl[]{this._solidIngredients[0], this._leftProgressBar, this._outputFluidBar, this._rightProgressBar, this._solidIngredients[1]});
            return p;
        }

        private Panel fluidMixingRecipePanel() {
            Panel p = this.panel();
            p.addControl(new IControl[]{this._fluidIngredients[0], this._leftProgressBar, this._outputFluidBar, this._rightProgressBar, this._fluidIngredients[1]});
            return p;
        }
    }
}

