/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.NonNullConsumer;

public enum Reactants implements NonNullConsumer<LivingEntity>
{
    Yellorium(ReactantType.Fuel, "yellorium", 13023828, MobEffects.f_19613_, MobEffects.f_19597_),
    Cyanite(ReactantType.Waste, "cyanite", 5474231, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_),
    Blutonium(ReactantType.Fuel, "blutonium", 1513372, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_, MobEffects.f_19614_),
    Magentite(ReactantType.Waste, "magentite", 14949860, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_, MobEffects.f_19615_),
    Verderium(ReactantType.Fuel, "verderium", 65280, MobEffects.f_19615_, MobEffects.f_19612_, MobEffects.f_19614_, MobEffects.f_19613_, MobEffects.f_19610_),
    Rossinite(ReactantType.Waste, "rossinite", 0xFF0000, MobEffects.f_19596_, MobEffects.f_19598_, MobEffects.f_19591_, MobEffects.f_19595_);

    private final ReactantType _type;
    private final String _name;
    private final int _colour;
    private final List<MobEffect> _effects;

    public ReactantType getType() {
        return this._type;
    }

    public String getReactantName() {
        return this._name;
    }

    public String getTagName() {
        return this._name;
    }

    public String getLangKey() {
        return "reactant.bigreactors." + this._name;
    }

    public String getBlockName() {
        return this._name + "_block";
    }

    public String getIngotName() {
        return this._name + "_ingot";
    }

    public String getNuggetName() {
        return this._name + "_nugget";
    }

    public String getDustName() {
        return this._name + "_dust";
    }

    public String getBucketName() {
        return this._name + "_bucket";
    }

    public String getFluidName() {
        return this._name + "_fluid";
    }

    public String getFluidSourceName() {
        return this._name;
    }

    public String getFluidFlowingName() {
        return this._name + "_flowing";
    }

    public int getColour() {
        return this._colour;
    }

    public void accept(@Nonnull LivingEntity entity) {
        this._effects.forEach(effect -> entity.m_7292_(new MobEffectInstance(effect, 400, 0, true, true, true)));
    }

    private Reactants(ReactantType type, String name, int colour, MobEffect ... effects) {
        this._type = type;
        this._name = name;
        this._colour = colour;
        this._effects = new ObjectArrayList((Object[])effects);
    }
}

