/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.IFluidPort;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.IFluidPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ReactorFluidPortEntity
extends AbstractReactorEntity
implements IFluidPort<MultiblockReactor, IMultiblockReactorVariant>,
INeighborChangeListener,
MenuProvider {
    private final IFluidPortHandler<MultiblockReactor, IMultiblockReactorVariant> _handler;
    private IoDirection _direction;

    public ReactorFluidPortEntity(FluidPortType type, IoMode mode, BlockEntityType<?> entityType, BlockPos position, BlockState blockState) {
        super(entityType, position, blockState);
        this._handler = IFluidPortHandler.create(type, mode, this);
        this.setIoDirection(IoDirection.Input);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).build((AbstractModBlockEntity)this));
    }

    @Override
    public IFluidPortHandler<MultiblockReactor, IMultiblockReactorVariant> getFluidPortHandler() {
        return this._handler;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections(this.m_58904_(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.getFluidPortHandler().update();
        this.executeOnController(MultiblockReactor::onFluidPortChanged);
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.m_6596_();
        }, this::markForRenderUpdate);
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundTag)data, (String)"iodir", (IoDirection)IoDirection.Input));
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundTag)data, (String)"iodir", (IoDirection)this.getIoDirection());
        return data;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return ModTileContainer.empty((MenuType)((MenuType)Content.ContainerTypes.REACTOR_FLUIDPORT.get()), (int)windowId, (Inventory)inventory, (AbstractModBlockEntity)this);
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getFluidPortHandler().isConnected() ? 1 : 0;
        return this.getIoDirection().isInput() ? 0 + connectedOffset : 2 + connectedOffset;
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        ReactorPartType partType = (ReactorPartType)this.getPartTypeOrDefault(ReactorPartType.Casing);
        return (ReactorPartType.ActiveFluidPortForge == partType || ReactorPartType.PassiveFluidPortForge == partType) && this.isMachineAssembled();
    }

    @Override
    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled(controller);
        this.getFluidPortHandler().update();
        this.notifyOutwardNeighborsOfStateChange();
    }

    @Override
    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.getFluidPortHandler().update();
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onAttached(MultiblockReactor newController) {
        super.onAttached((IMultiblockController)newController);
        this.getFluidPortHandler().update();
    }

    public void onAssimilated(MultiblockReactor newController) {
        super.onAssimilated((IMultiblockController)newController);
        this.getFluidPortHandler().update();
    }

    public void onDetached(MultiblockReactor oldController) {
        super.onDetached((IMultiblockController)oldController);
        this.getFluidPortHandler().update();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional cap = this.getFluidPortHandler().getCapability(capability, side);
        return null != cap ? cap : super.getCapability(capability, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.getFluidPortHandler().invalidate();
    }
}

