/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.inventory.bit;

import java.util.Map;
import mod.chiselsandbits.api.item.bit.IBitItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public interface IBitInventory {
    default public boolean canExtractOne(BlockState blockState) {
        return this.canExtract(blockState, 1);
    }

    public boolean canExtract(BlockState var1, int var2);

    public int getMaxExtractAmount(BlockState var1);

    default public void extractOne(BlockState blockState) throws IllegalArgumentException {
        this.extract(blockState, 1);
    }

    public void extract(BlockState var1, int var2) throws IllegalArgumentException;

    default public boolean canInsertOne(BlockState blockState) {
        return this.canInsert(blockState, 1);
    }

    public boolean canInsert(BlockState var1, int var2);

    public int getMaxInsertAmount(BlockState var1);

    default public void insertOne(BlockState blockState) throws IllegalArgumentException {
        this.insert(blockState, 1);
    }

    public void insert(BlockState var1, int var2) throws IllegalArgumentException;

    default public void insertOrDiscard(BlockState blockState, int count) {
        this.insert(blockState, Math.min(this.getMaxInsertAmount(blockState), count));
    }

    public boolean isEmpty();

    default public ItemStack insert(ItemStack stack) {
        if (!(stack.m_41720_() instanceof IBitItem)) {
            return stack;
        }
        IBitItem bitItem = (IBitItem)stack.m_41720_();
        BlockState blockState = bitItem.getBitState(stack);
        int maxToInsertCount = this.getMaxInsertAmount(blockState);
        int maxToInsertFromStack = Math.min(stack.m_41613_(), maxToInsertCount);
        int maxRemainingOnStack = stack.m_41613_() - maxToInsertCount;
        this.insert(blockState, maxToInsertFromStack);
        ItemStack resultStack = stack.m_41777_();
        resultStack.m_41764_(maxRemainingOnStack);
        return resultStack;
    }

    public Map<BlockState, Integer> getContainedStates();
}

