/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.multistate;

import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import net.minecraft.world.phys.Vec3;

public enum StateEntrySize {
    ONE_SIXTEENTH(16),
    ONE_EIGHT(8),
    ONE_QUARTER(4),
    ONE_HALF(2),
    ONE(1);

    private static StateEntrySize _current;
    private final int bitsPerBlockSide;
    private final int bitsPerBlock;
    private final int bitsPerLayer;
    private final float sizePerBit;
    private final float sizePerHalfBit;

    public static StateEntrySize current() {
        if (_current == null) {
            _current = IChiselsAndBitsAPI.getInstance() == null ? ONE_SIXTEENTH : IChiselsAndBitsAPI.getInstance().getStateEntrySize();
        }
        return _current;
    }

    private StateEntrySize(int bitsPerBlockSide) {
        this.bitsPerBlockSide = bitsPerBlockSide;
        this.bitsPerBlock = this.bitsPerBlockSide * this.bitsPerBlockSide * this.bitsPerBlockSide;
        this.bitsPerLayer = this.bitsPerBlockSide * this.bitsPerBlockSide;
        this.sizePerBit = 1.0f / (float)bitsPerBlockSide;
        this.sizePerHalfBit = this.sizePerBit / 2.0f;
    }

    public int getBitsPerBlockSide() {
        return this.bitsPerBlockSide;
    }

    public int getBitsPerBlock() {
        return this.bitsPerBlock;
    }

    public int getBitsPerLayer() {
        return this.bitsPerLayer;
    }

    public float getSizePerBit() {
        return this.sizePerBit;
    }

    public Vec3 getSizePerBitScalingVector() {
        return new Vec3((double)this.sizePerBit, (double)this.sizePerBit, (double)this.sizePerBit);
    }

    public Vec3 getSizePerHalfBitScalingVector() {
        return new Vec3((double)this.sizePerHalfBit, (double)this.sizePerHalfBit, (double)this.sizePerHalfBit);
    }

    public Vec3 getBitsPerBlockSideScalingVector() {
        return new Vec3((double)this.bitsPerBlockSide, (double)this.bitsPerBlockSide, (double)this.bitsPerBlockSide);
    }

    public float getSizePerHalfBit() {
        return this.sizePerHalfBit;
    }

    public float upperLevelY() {
        return this.getBitsPerLayer() - 1;
    }

    static {
        _current = null;
    }
}

