/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.block.bitbag.IBitBagAcceptingBlock;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitStorageBlock
extends Block
implements EntityBlock,
IBitBagAcceptingBlock {
    public static final Property<Direction> FACING = HorizontalDirectionalBlock.f_54117_;

    public BitStorageBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BitStorageBlockEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof BitStorageBlockEntity)) {
            return InteractionResult.FAIL;
        }
        BitStorageBlockEntity tank = (BitStorageBlockEntity)tileEntity;
        ItemStack current = player.m_150109_().m_36056_();
        if (current.m_41720_() instanceof BitBagItem) {
            return InteractionResult.PASS;
        }
        if (!current.m_41619_() ? tank.addHeldBits(current, player) : tank.addAllPossibleBits(player)) {
            return InteractionResult.SUCCESS;
        }
        if (tank.extractBits(player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public float m_7749_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull BlockState state) {
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (!(blockEntity instanceof BitStorageBlockEntity)) {
            return super.m_7397_(blockGetter, blockPos, state);
        }
        BitStorageBlockEntity bitStorageBlockEntity = (BitStorageBlockEntity)blockEntity;
        return this.getTankDrop(bitStorageBlockEntity);
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, LootContext.Builder builder) {
        if (builder.m_78982_(LootContextParams.f_81462_) == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getTankDrop((BitStorageBlockEntity)Objects.requireNonNull((BlockEntity)builder.m_78982_(LootContextParams.f_81462_)))});
    }

    public ItemStack getTankDrop(BitStorageBlockEntity bitTank) {
        Optional<FluidInformation> fluidInformation;
        ItemStack tankStack = new ItemStack((ItemLike)ModItems.ITEM_BIT_STORAGE.get());
        if (bitTank.containsFluid() && (fluidInformation = bitTank.getFluid()).isPresent()) {
            return IFluidManager.getInstance().insertInto(tankStack, fluidInformation.get());
        }
        return tankStack;
    }

    @Override
    public void onBitBagInteraction(ItemStack bitBagStack, Player player, BlockHitResult blockRayTraceResult) {
        Optional<BlockState> toExtractCandidate;
        BlockEntity tileEntity = player.f_19853_.m_7702_(blockRayTraceResult.m_82425_());
        if (!(tileEntity instanceof BitStorageBlockEntity)) {
            return;
        }
        BitStorageBlockEntity storage = (BitStorageBlockEntity)tileEntity;
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(bitBagStack);
        BlockState containedState = storage.getState();
        if (player.m_6047_() && containedState != null) {
            int maxAmountToInsert = bitInventory.getMaxInsertAmount(containedState);
            int bitCountToInsert = Math.min(storage.getBits(), maxAmountToInsert);
            storage.extractBits(bitCountToInsert);
            bitInventory.insert(containedState, bitCountToInsert);
        } else if (containedState != null && storage.getBits() != 0) {
            int maxAmountToInsert = StateEntrySize.current().getBitsPerBlock() - storage.getBits();
            int bitCountToInsert = Math.min(bitInventory.getMaxExtractAmount(containedState), maxAmountToInsert);
            storage.insertBits(bitCountToInsert, containedState);
            bitInventory.extract(containedState, bitCountToInsert);
        } else if (!player.m_6047_() && (toExtractCandidate = bitInventory.getContainedStates().entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey)).isPresent()) {
            BlockState toExtractState = toExtractCandidate.get();
            int maxAmountToInsert = StateEntrySize.current().getBitsPerBlock();
            int bitCountToInsert = Math.min(bitInventory.getMaxExtractAmount(toExtractState), maxAmountToInsert);
            storage.insertBits(bitCountToInsert, toExtractState);
            bitInventory.extract(toExtractState, bitCountToInsert);
        }
    }
}

