/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import java.util.Optional;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.block.BitStorageBlock;
import mod.chiselsandbits.platforms.core.blockstate.ILevelBasedPropertyAccessor;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import mod.chiselsandbits.registrars.ModBlockEntityTypes;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BitStorageBlockEntity
extends BlockEntity
implements Container {
    private BlockState state = null;
    private int bits = 0;
    private int oldLV = -1;

    public BitStorageBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.BIT_STORAGE.get(), pos, state);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("state")) {
            CompoundTag stateCompound = nbt.m_128469_("state");
            this.state = NbtUtils.m_129241_((CompoundTag)stateCompound);
        } else {
            int rawState = nbt.m_128451_("blockstate");
            this.state = rawState != -1 ? IBlockStateIdManager.getInstance().getBlockStateFrom(rawState) : null;
        }
        this.bits = this.state != null ? nbt.m_128451_("bits") : 0;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("state", (Tag)(this.state == null ? new CompoundTag() : NbtUtils.m_129202_((BlockState)this.state)));
        compound.m_128405_("bits", this.bits);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public boolean addAllPossibleBits(Player playerIn) {
        if (playerIn != null && playerIn.m_6144_() && this.state != null && !this.state.m_60795_()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(playerIn);
            int extractionAmount = Math.min(StateEntrySize.current().getBitsPerBlock() - this.bits, bitInventory.getMaxExtractAmount(this.state));
            bitInventory.extract(this.state, extractionAmount);
            this.bits += extractionAmount;
            this.saveAndUpdate();
        }
        return false;
    }

    private void saveAndUpdate() {
        if (this.f_58857_ == null || this.m_58904_() == null) {
            return;
        }
        if (this.bits == 0) {
            this.state = null;
        }
        if (this.state == null) {
            this.bits = 0;
        }
        this.m_6596_();
        this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 0);
        int lv = this.getLightValue();
        if (this.oldLV != lv) {
            this.m_58904_().m_5518_().m_142202_(this.m_58899_());
            this.oldLV = lv;
        }
    }

    public int getLightValue() {
        return ILevelBasedPropertyAccessor.getInstance().getLightEmission(new SingleBlockWorldReader(this.state == null ? Blocks.f_50016_.m_49966_() : this.state, this.m_58899_(), (LevelReader)this.m_58904_()), this.m_58899_());
    }

    public boolean addHeldBits(ItemStack current, Player playerIn) {
        if (current.m_41619_()) {
            return false;
        }
        if (playerIn.m_6144_() || this.bits == 0) {
            Optional<FluidInformation> containedFluid;
            BlockState stackState;
            Item item = current.m_41720_();
            if (item instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)item;
                if (bitItem.getBitState(current) == this.state || this.state == null) {
                    this.state = bitItem.getBitState(current);
                    int maxToInsert = StateEntrySize.current().getBitsPerBlock() - this.bits;
                    int toInsert = Math.min(maxToInsert, current.m_41613_());
                    this.bits += toInsert;
                    if (!playerIn.m_7500_()) {
                        current.m_41774_(toInsert);
                        playerIn.m_150109_().m_6836_(playerIn.m_150109_().f_35977_, current);
                        playerIn.m_150109_().m_6596_();
                    }
                    this.saveAndUpdate();
                    return true;
                }
            } else if (IEligibilityManager.getInstance().canBeChiseled((ItemLike)current.m_41720_()) && (stackState = ItemStackUtils.getStateFromItem(current)).m_60734_() != Blocks.f_50016_ && (this.state == null || this.state.m_60795_())) {
                this.state = stackState;
                this.bits = StateEntrySize.current().getBitsPerBlock();
                if (!playerIn.m_7500_()) {
                    current.m_41774_(1);
                    playerIn.m_150109_().m_6836_(playerIn.m_150109_().f_35977_, current);
                    playerIn.m_150109_().m_6596_();
                }
                this.saveAndUpdate();
                return true;
            }
            if ((containedFluid = IFluidManager.getInstance().get(current)).isPresent() && containedFluid.get().amount() > 0L) {
                BlockState state = containedFluid.get().fluid().m_76145_().m_76188_();
                if (IEligibilityManager.getInstance().canBeChiseled(state)) {
                    int maxToInsert = StateEntrySize.current().getBitsPerBlock() - this.bits;
                    int toInsert = (int)Math.min((float)maxToInsert, this.getBitCountFrom(containedFluid.get()));
                    this.bits += toInsert;
                    if (!playerIn.m_7500_()) {
                        ItemStack resultStack = IFluidManager.getInstance().extractFrom(current, toInsert);
                        playerIn.m_150109_().m_6836_(playerIn.m_150109_().f_35977_, resultStack);
                        playerIn.m_150109_().m_6596_();
                    }
                    this.saveAndUpdate();
                    return true;
                }
            }
        }
        return false;
    }

    private float getBitCountFrom(FluidInformation containedFluid) {
        return (float)StateEntrySize.current().getBitsPerBlock() * ((float)containedFluid.amount() / (float)IFluidManager.getInstance().getBucketAmount());
    }

    public boolean extractBits(Player playerIn) {
        if (!playerIn.m_6144_()) {
            Item item;
            ItemStack is = this.m_8020_(0);
            if (!is.m_41619_() && (item = is.m_41720_()) instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)item;
                BlockState blockState = bitItem.getBitState(is);
                BitInventoryUtils.insertIntoOrSpawn(playerIn, blockState, is.m_41613_());
                this.m_7407_(0, is.m_41613_());
            }
            return true;
        }
        return false;
    }

    public BlockState getState() {
        return this.state;
    }

    public int getBits() {
        return this.bits;
    }

    public Direction getFacing() {
        return (Direction)this.m_58904_().m_8055_(this.m_58899_()).m_61143_(BitStorageBlock.FACING);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.state == null || this.bits == 0;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index != 0) {
            return ItemStack.f_41583_;
        }
        if (this.state == null) {
            return ItemStack.f_41583_;
        }
        return IBitItemManager.getInstance().create(this.state, Math.min(64, this.bits));
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        if (index != 0) {
            return ItemStack.f_41583_;
        }
        BlockState currentState = this.state;
        int toRemove = Math.min(count, this.bits);
        this.bits -= toRemove;
        this.saveAndUpdate();
        return IBitItemManager.getInstance().create(currentState, toRemove);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack itemStack) {
        if (index != 0 || !(itemStack.m_41720_() instanceof IBitItem) || ((IBitItem)itemStack.m_41720_()).getBitState(itemStack) == this.state) {
            return;
        }
        this.saveAndUpdate();
        this.bits = Math.max(StateEntrySize.current().getBitsPerBlock(), this.bits + itemStack.m_41613_());
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.state = null;
        this.bits = 0;
        this.saveAndUpdate();
    }

    public Optional<FluidInformation> getFluid() {
        if (!this.containsFluid()) {
            return Optional.empty();
        }
        return Optional.of(new FluidInformation(((LiquidBlock)this.state.m_60734_()).m_5888_(this.state).m_76152_(), (long)((float)this.bits / ((float)StateEntrySize.current().getBitsPerBlock() / (float)IFluidManager.getInstance().getBucketAmount())), new CompoundTag()));
    }

    public boolean containsFluid() {
        LiquidBlock liquidBlock;
        Block block;
        return this.state != null && (block = this.state.m_60734_()) instanceof LiquidBlock && !(liquidBlock = (LiquidBlock)block).m_5888_(this.state).m_76178_();
    }

    public void extractBits(int count) {
        this.bits = Math.max(0, this.bits - count);
        if (this.bits <= 0) {
            this.state = null;
        }
        this.saveAndUpdate();
    }

    public void insertBits(int bitCountToInsert, BlockState containedState) {
        if (this.state == null || containedState == this.state) {
            this.bits = Math.max(StateEntrySize.current().getBitsPerBlock(), bitCountToInsert + this.bits);
            this.state = containedState;
            this.saveAndUpdate();
        }
    }

    public void insertBitsFromFluid(FluidInformation fluidInformation) {
        if (this.state == null || this.state == fluidInformation.fluid().m_76145_().m_76188_()) {
            this.bits = (int)Math.max((float)StateEntrySize.current().getBitsPerBlock(), this.getBitCountFrom(fluidInformation) + (float)this.bits);
            this.state = fluidInformation.fluid().m_76145_().m_76188_();
            this.saveAndUpdate();
        }
    }

    public void setContents(BlockState blockState, int count) {
        this.state = blockState;
        this.bits = count;
        this.saveAndUpdate();
    }
}

