/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.utils.BlockStateSerializationUtils;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SimpleStateEntryPalette
implements IPacketBufferSerializable,
INBTSerializable<ListTag> {
    private final List<Entry> paletteEntries = Collections.synchronizedList(Lists.newArrayList());
    private final BiMap<BlockState, Entry> paletteMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private final IntConsumer onNewSizeAddedConsumer;

    public SimpleStateEntryPalette(IntConsumer onNewSizeAddedConsumer) {
        this.onNewSizeAddedConsumer = onNewSizeAddedConsumer;
        this.clear();
    }

    public SimpleStateEntryPalette(IntConsumer onPaletteResize, SimpleStateEntryPalette palette) {
        this.onNewSizeAddedConsumer = onPaletteResize;
        this.paletteEntries.addAll(palette.paletteEntries);
        this.paletteMap.putAll(palette.paletteMap);
    }

    @Override
    public ListTag serializeNBT() {
        return this.paletteEntries.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(ListTag::new));
    }

    @Override
    public void deserializeNBT(ListTag nbt) {
        int currentSize = this.paletteEntries.size();
        this.paletteEntries.clear();
        nbt.stream().filter(StringTag.class::isInstance).map(StringTag.class::cast).map(Entry::new).forEach(this.paletteEntries::add);
        this.paletteEntries.forEach(entry -> this.paletteMap.put((Object)entry.get(), entry));
        if (this.paletteEntries.size() == 0) {
            this.clear();
        }
        if (currentSize != this.paletteEntries.size()) {
            this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        }
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130130_(this.paletteEntries.size());
        this.paletteEntries.forEach(entry -> entry.serializeInto(packetBuffer));
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        int currentSize = this.paletteEntries.size();
        this.paletteEntries.clear();
        this.paletteMap.clear();
        int newCount = packetBuffer.m_130242_();
        for (int i = 0; i < newCount; ++i) {
            this.paletteEntries.add(new Entry(packetBuffer));
        }
        this.paletteEntries.forEach(entry -> this.paletteMap.put((Object)entry.get(), entry));
        if (this.paletteEntries.size() == 0) {
            this.clear();
        }
        if (currentSize != this.paletteEntries.size()) {
            this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        }
    }

    public int getIndex(BlockState state) {
        if (this.paletteMap.containsKey((Object)state)) {
            Entry entry = (Entry)this.paletteMap.get((Object)state);
            return this.paletteEntries.indexOf(entry);
        }
        Entry newEntry = new Entry(state);
        this.paletteMap.put((Object)state, (Object)newEntry);
        this.paletteEntries.add(newEntry);
        this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        return this.paletteEntries.size() - 1;
    }

    public BlockState getBlockState(int blockStateId) {
        if (blockStateId < 0 || blockStateId >= this.paletteEntries.size()) {
            return this.getBlockState(0);
        }
        return this.paletteEntries.get(blockStateId).get();
    }

    public void sanitize(Collection<BlockState> toRemove) {
        List<Entry> toRemoveList = toRemove.stream().map(arg_0 -> this.paletteMap.get(arg_0)).toList();
        this.paletteEntries.removeAll(toRemoveList);
        toRemove.forEach(arg_0 -> this.paletteMap.remove(arg_0));
        this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
    }

    public void clear() {
        this.paletteEntries.clear();
        this.paletteMap.clear();
        this.getIndex(Blocks.f_50016_.m_49966_());
    }

    public List<BlockState> getStates() {
        return this.paletteMap.keySet().stream().toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleStateEntryPalette)) {
            return false;
        }
        SimpleStateEntryPalette that = (SimpleStateEntryPalette)o;
        return this.paletteEntries.equals(that.paletteEntries);
    }

    public int hashCode() {
        return this.paletteEntries.hashCode();
    }

    public String toString() {
        return "SimpleStateEntryPalette{paletteEntries=" + this.paletteEntries + "}";
    }

    private static final class Entry
    implements IPacketBufferSerializable,
    INBTSerializable<StringTag> {
        private BlockState outwardFacingState;
        private String rawSpec;

        private Entry(BlockState newState) {
            this.outwardFacingState = newState;
            this.rawSpec = BlockStateSerializationUtils.serialize(newState);
        }

        private Entry(StringTag tag) {
            this.deserializeNBT(tag);
        }

        private Entry(FriendlyByteBuf buffer) {
            this.deserializeFrom(buffer);
        }

        @Override
        public StringTag serializeNBT() {
            return StringTag.m_129297_((String)this.rawSpec);
        }

        @Override
        public void deserializeNBT(StringTag nbt) {
            this.rawSpec = nbt.m_7916_();
            DataResult<BlockState> result = BlockStateSerializationUtils.deserialize(this.rawSpec);
            this.outwardFacingState = result.result().orElseGet(() -> ((Block)Blocks.f_50016_).m_49966_());
        }

        @Override
        public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
            packetBuffer.m_130070_(this.rawSpec);
        }

        @Override
        public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
            this.rawSpec = packetBuffer.m_130277_();
            DataResult<BlockState> result = BlockStateSerializationUtils.deserialize(this.rawSpec);
            this.outwardFacingState = result.result().orElseGet(() -> ((Block)Blocks.f_50016_).m_49966_());
        }

        public BlockState get() {
            return this.outwardFacingState;
        }
    }
}

