/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.chiseling.preview.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.client.chiseling.preview.render.IChiselContextPreviewRenderer;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConfigurableColoredVoxelShapeChiselContextPreviewRenderer
implements IChiselContextPreviewRenderer {
    static ResourceLocation ID = new ResourceLocation("chiselsandbits", "default");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void renderExistingContextsBoundingBox(PoseStack poseStack, IChiselingContext currentContextSnapshot) {
        if (currentContextSnapshot.getMutator().isEmpty()) {
            return;
        }
        Vec3 Vec32 = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double xView = Vec32.m_7096_();
        double yView = Vec32.m_7098_();
        double zView = Vec32.m_7094_();
        BlockPos inWorldStartPos = new BlockPos(currentContextSnapshot.getMutator().get().getInWorldStartPoint());
        VoxelShape boundingShape = VoxelShapeManager.getInstance().get(currentContextSnapshot.getMutator().get(), currentContextSnapshot.getModeOfOperandus().isChiseling() ? CollisionType.NONE_AIR : CollisionType.ALL, false);
        VoxelShape modeShape = currentContextSnapshot.getMode().getShape(currentContextSnapshot);
        VoxelShape renderedShape = Shapes.m_83148_((VoxelShape)boundingShape, (VoxelShape)modeShape, (BooleanOp)BooleanOp.f_82689_);
        List<? extends Float> color = currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING ? IClientConfiguration.getInstance().getPreviewChiselingColor().get() : IClientConfiguration.getInstance().getPreviewPlacementColor().get();
        List<? extends Float> mutatorColor = currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING ? IClientConfiguration.getInstance().getMutatorPreviewChiselingColor().get() : IClientConfiguration.getInstance().getMutatorPreviewPlacementColor().get();
        RenderSystem.m_69465_();
        LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(ModRenderTypes.MEASUREMENT_LINES.get()), (VoxelShape)renderedShape, (double)((double)inWorldStartPos.m_123341_() - xView), (double)((double)inWorldStartPos.m_123342_() - yView), (double)((double)inWorldStartPos.m_123343_() - zView), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 0, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 1, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 2, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(color, 3, 1.0f));
        Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(ModRenderTypes.MEASUREMENT_LINES.get());
        RenderSystem.m_69482_();
        if (IClientConfiguration.getInstance().getMutatorPreviewDebug().get().booleanValue()) {
            RenderSystem.m_69465_();
            LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(ModRenderTypes.MEASUREMENT_LINES.get()), (VoxelShape)boundingShape, (double)((double)inWorldStartPos.m_123341_() - xView), (double)((double)inWorldStartPos.m_123342_() - yView), (double)((double)inWorldStartPos.m_123343_() - zView), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(mutatorColor, 0, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(mutatorColor, 1, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(mutatorColor, 2, 0.0f), (float)ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.getColorValue(mutatorColor, 3, 1.0f));
            Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(ModRenderTypes.MEASUREMENT_LINES.get());
            RenderSystem.m_69482_();
        }
    }

    private static float getColorValue(List<? extends Float> values, int index, float defaultValue) {
        if (values.size() <= index || index < 0) {
            return defaultValue;
        }
        Number value = values.get(index);
        if (0.0f <= value.floatValue() && value.floatValue() <= 1.0f) {
            return value.floatValue();
        }
        return defaultValue;
    }

    private static final class InternalContextFilter
    implements Predicate<IStateEntryInfo> {
        private final Predicate<IStateEntryInfo> placingContextPredicate;

        private InternalContextFilter(Predicate<IStateEntryInfo> placingContextPredicate) {
            this.placingContextPredicate = placingContextPredicate;
        }

        @Override
        public boolean test(IStateEntryInfo s) {
            return (s.getState().m_60795_() || IEligibilityManager.getInstance().canBeChiseled(s.getState())) && this.placingContextPredicate.test(s);
        }

        public int hashCode() {
            return this.placingContextPredicate != null ? this.placingContextPredicate.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InternalContextFilter)) {
                return false;
            }
            InternalContextFilter that = (InternalContextFilter)o;
            return Objects.equals(this.placingContextPredicate, that.placingContextPredicate);
        }
    }
}

