/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.logic;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.chiselsandbits.api.item.wireframe.IWireframeProvidingItem;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.client.render.ChiseledBlockWireframeRenderer;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultiStateBlockPreviewRenderHandler {
    public static void renderMultiStateBlockPreview(PoseStack poseStack) {
        LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
        if (playerEntity == null) {
            return;
        }
        ItemStack heldStack = ItemStackUtils.getMultiStateItemStackFromPlayer((Player)playerEntity);
        if (heldStack.m_41619_()) {
            return;
        }
        Item heldItem = heldStack.m_41720_();
        if (!(heldItem instanceof IWireframeProvidingItem)) {
            return;
        }
        IWireframeProvidingItem wireframeItem = (IWireframeProvidingItem)heldItem;
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer((Player)playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (!(rayTraceResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        VoxelShape wireFrame = wireframeItem.getWireFrame(heldStack, (Player)playerEntity, blockRayTraceResult);
        Vec3 color = wireframeItem.getWireFrameColor(heldStack, (Player)playerEntity, blockRayTraceResult);
        Vec3 targetedRenderPos = wireframeItem.getTargetedBlockPos(heldStack, (Player)playerEntity, blockRayTraceResult);
        ChiseledBlockWireframeRenderer.getInstance().renderShape(poseStack, wireFrame, targetedRenderPos, color);
    }
}

