/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face.model;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import mod.chiselsandbits.client.model.baked.face.model.BaseModelReader;
import mod.chiselsandbits.utils.ModelUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ModelUVReader
extends BaseModelReader {
    private final float minU;
    private final float maxUMinusMin;
    private final float minV;
    private final float maxVMinusMin;
    private final float[] quadUVs = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private final int uCoord;
    private final int vCoord;
    private float[] pos;
    private float[] uv;
    private int corners;

    public ModelUVReader(TextureAtlasSprite texture, int uFaceCoord, int vFaceCoord) {
        this.minU = texture.m_118409_();
        this.maxUMinusMin = texture.m_118410_() - this.minU;
        this.minV = texture.m_118411_();
        this.maxVMinusMin = texture.m_118412_() - this.minV;
        this.uCoord = uFaceCoord;
        this.vCoord = vFaceCoord;
    }

    @Override
    public void put(int element, float ... data) {
        VertexFormat format = this.getVertexFormat();
        VertexFormatElement ele = (VertexFormatElement)format.m_86023_().get(element);
        if (ele.m_86048_() == VertexFormatElement.Usage.UV && ele.m_86049_() == 0) {
            this.uv = Arrays.copyOf(data, data.length);
        } else if (ele.m_86048_() == VertexFormatElement.Usage.POSITION) {
            this.pos = Arrays.copyOf(data, data.length);
        }
        if (element == format.m_86023_().size() - 1) {
            if (ModelUtil.isZero(this.pos[this.uCoord]) && ModelUtil.isZero(this.pos[this.vCoord])) {
                this.corners |= 1;
                this.quadUVs[0] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[1] = (this.uv[1] - this.minV) / this.maxVMinusMin;
            } else if (ModelUtil.isZero(this.pos[this.uCoord]) && ModelUtil.isOne(this.pos[this.vCoord])) {
                this.corners |= 2;
                this.quadUVs[4] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[5] = (this.uv[1] - this.minV) / this.maxVMinusMin;
            } else if (ModelUtil.isOne(this.pos[this.uCoord]) && ModelUtil.isZero(this.pos[this.vCoord])) {
                this.corners |= 4;
                this.quadUVs[2] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[3] = (this.uv[1] - this.minV) / this.maxVMinusMin;
            } else if (ModelUtil.isOne(this.pos[this.uCoord]) && ModelUtil.isOne(this.pos[this.vCoord])) {
                this.corners |= 8;
                this.quadUVs[6] = (this.uv[0] - this.minU) / this.maxUMinusMin;
                this.quadUVs[7] = (this.uv[1] - this.minV) / this.maxVMinusMin;
            }
        }
    }

    public float[] getQuadUVs() {
        return this.quadUVs;
    }
}

