/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.client.rendering;

import java.util.Optional;
import java.util.function.Predicate;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import org.jetbrains.annotations.NotNull;

public class ForgeRenderTypeManager
implements IRenderTypeManager {
    private static final ForgeRenderTypeManager INSTANCE = new ForgeRenderTypeManager();

    public static ForgeRenderTypeManager getInstance() {
        return INSTANCE;
    }

    private ForgeRenderTypeManager() {
    }

    @Override
    @NotNull
    public Optional<RenderType> getCurrentRenderType() {
        return Optional.ofNullable(MinecraftForgeClient.getRenderType());
    }

    @Override
    public void setCurrentRenderType(RenderType renderType) {
        ForgeHooksClient.setRenderType((RenderType)renderType);
    }

    @Override
    public boolean canRenderInType(BlockState blockState, RenderType renderType) {
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)renderType);
    }

    @Override
    public boolean canRenderInType(FluidState fluidState, RenderType renderType) {
        return ItemBlockRenderTypes.canRenderInLayer((FluidState)fluidState, (RenderType)renderType);
    }

    @Override
    public void setPossibleRenderTypesFor(Block block, RenderType defaultRenderType, Predicate<RenderType> dynamicSelector) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, dynamicSelector);
    }
}

