/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.client.rendering;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Optional;
import mod.chiselsandbits.forge.platform.client.rendering.ForgeRenderTypeManager;
import mod.chiselsandbits.platforms.core.client.rendering.IRenderingManager;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ForgeRenderingManager
implements IRenderingManager {
    private static final ForgeRenderingManager INSTANCE = new ForgeRenderingManager();
    private final Map<Item, BlockEntityWithoutLevelRenderer> bewlrs = Maps.newConcurrentMap();

    public static ForgeRenderingManager getInstance() {
        return INSTANCE;
    }

    private ForgeRenderingManager() {
    }

    @Override
    public void renderModel(PoseStack.Pose last, VertexConsumer buffer, BlockState defaultBlockState, BakedModel model, float r, float g, float b, int combinedLight, int combinedOverlay) {
        Minecraft.m_91087_().m_91289_().m_110937_().renderModel(last, buffer, defaultBlockState, model, r, g, b, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
    }

    @Override
    public ResourceLocation getFlowingFluidTexture(FluidInformation fluidInformation) {
        return fluidInformation.fluid().getAttributes().getFlowingTexture(this.buildFluidStack(fluidInformation));
    }

    @Override
    public ResourceLocation getFlowingFluidTexture(Fluid fluid) {
        return fluid.getAttributes().getFlowingTexture();
    }

    @Override
    public ResourceLocation getStillFluidTexture(FluidInformation fluidInformation) {
        return fluidInformation.fluid().getAttributes().getStillTexture(this.buildFluidStack(fluidInformation));
    }

    @Override
    public ResourceLocation getStillFluidTexture(Fluid fluid) {
        return fluid.getAttributes().getStillTexture();
    }

    @Override
    @NotNull
    public IRenderTypeManager getRenderTypeManager() {
        return ForgeRenderTypeManager.getInstance();
    }

    @Override
    public void registerISTER(Item item, BlockEntityWithoutLevelRenderer renderer) {
        this.bewlrs.put(item, renderer);
    }

    public Optional<BlockEntityWithoutLevelRenderer> getRenderer(Item item) {
        return Optional.ofNullable(this.bewlrs.get(item));
    }

    @NotNull
    private FluidStack buildFluidStack(FluidInformation fluid) {
        if (fluid.data() == null) {
            return new FluidStack(fluid.fluid(), (int)fluid.amount());
        }
        return new FluidStack(fluid.fluid(), (int)fluid.amount(), fluid.data());
    }
}

