/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.configuration;

import com.google.common.collect.Sets;
import java.util.Set;
import mod.chiselsandbits.forge.platform.configuration.ForgeDelegateConfigurationBuilder;
import mod.chiselsandbits.platforms.core.config.ConfigurationType;
import mod.chiselsandbits.platforms.core.config.IConfigurationBuilder;
import mod.chiselsandbits.platforms.core.config.IConfigurationManager;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfigurationManager
implements IConfigurationManager {
    private static final ForgeConfigurationManager INSTANCE = new ForgeConfigurationManager();
    private final Set<String> availableKeys = Sets.newConcurrentHashSet();

    public static ForgeConfigurationManager getInstance() {
        return INSTANCE;
    }

    private ForgeConfigurationManager() {
    }

    @Override
    public IConfigurationBuilder createBuilder(ConfigurationType type, String name) {
        return new ForgeDelegateConfigurationBuilder(forgeConfigSpec -> {
            ModConfig config = new ModConfig(ForgeConfigurationManager.remapType(type), (IConfigSpec)forgeConfigSpec, ModLoadingContext.get().getActiveContainer(), String.format("%s.toml", name));
            ModLoadingContext.get().getActiveContainer().addConfig(config);
        }, this.availableKeys::add);
    }

    private static ModConfig.Type remapType(ConfigurationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationType.CLIENT_ONLY -> ModConfig.Type.CLIENT;
            case ConfigurationType.NOT_SYNCED -> ModConfig.Type.COMMON;
            case ConfigurationType.SYNCED -> ModConfig.Type.SERVER;
        };
    }

    public Set<String> getAvailableKeys() {
        return this.availableKeys;
    }
}

