/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.configuration;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.chiselsandbits.platforms.core.config.IConfigurationBuilder;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import mod.chiselsandbits.utils.LanguageHandler;
import net.minecraft.locale.Language;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeDelegateConfigurationBuilder
implements IConfigurationBuilder {
    private final Consumer<ForgeConfigSpec> specConsumer;
    private final Consumer<String> keyConsumer;
    private final ForgeConfigSpec.Builder builder;
    private final Set<String> keys = Sets.newConcurrentHashSet();

    public ForgeDelegateConfigurationBuilder(Consumer<ForgeConfigSpec> specConsumer, Consumer<String> keyConsumer) {
        this.specConsumer = specConsumer;
        this.keyConsumer = keyConsumer;
        this.builder = new ForgeConfigSpec.Builder();
    }

    @Override
    public Supplier<Boolean> defineBoolean(String key, boolean defaultValue) {
        this.keys.add(key + ".comment");
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal("mod.chiselsandbits.config." + key + ".comment"));
        return () -> ((ForgeConfigSpec.BooleanValue)this.builder.define(key, defaultValue)).get();
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String key, List<T> defaultValue, Class<T> containedType) {
        this.keys.add(key + ".comment");
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal(key + ".comment"));
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.defineList(key, defaultValue, t -> true)).get();
    }

    @Override
    public Supplier<String> defineString(String key, String defaultValue) {
        this.keys.add(key + ".comment");
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal(key + ".comment"));
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.define(key, (Object)defaultValue)).get();
    }

    @Override
    public Supplier<Long> defineLong(String key, long defaultValue, long minValue, long maxValue) {
        this.keys.add(key + ".comment");
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal(key + ".comment"));
        return () -> ((ForgeConfigSpec.LongValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public Supplier<Integer> defineInteger(String key, int defaultValue, int minValue, int maxValue) {
        this.keys.add(key + ".comment");
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal(key + ".comment"));
        return () -> ((ForgeConfigSpec.IntValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public Supplier<Double> defineDouble(String key, double defaultValue, double minValue, double maxValue) {
        this.keys.add(key + ".comment");
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal(key + ".comment"));
        return () -> ((ForgeConfigSpec.DoubleValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public <T extends Enum<T>> Supplier<T> defineEnum(String key, T defaultValue) {
        this.keys.add(key + ".comment");
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal(key + ".comment"));
        return () -> ((ForgeConfigSpec.EnumValue)this.builder.defineEnum(key, defaultValue)).get();
    }

    @Override
    public void setup() {
        this.keys.forEach(this.keyConsumer);
        this.specConsumer.accept(this.builder.build());
    }

    public static String translateToLocal(String string) {
        return (String)DistExecutor.unsafeRunForDist(() -> () -> {
            String translated = Language.m_128107_().m_6834_(string);
            if (translated.equals(string)) {
                return LanguageHandler.translateKey(string);
            }
            return translated;
        }, () -> () -> LanguageHandler.translateKey(string));
    }
}

