/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractBitInventory
implements IBitInventory {
    protected AbstractBitInventory() {
    }

    @Override
    public boolean canExtract(BlockState blockState, int count) {
        int contained = this.getMaxExtractAmount(blockState);
        return count <= contained;
    }

    @Override
    public int getMaxExtractAmount(BlockState blockState) {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::getItem).filter(stack -> stack.m_41720_() instanceof IBitItem || stack.m_41720_() instanceof IBitInventoryItem).mapToInt(stack -> {
            if (stack.m_41720_() instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)stack.m_41720_();
                if (bitItem.getBitState((ItemStack)stack) == blockState) {
                    return stack.m_41613_();
                }
                return 0;
            }
            if (stack.m_41720_() instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)stack.m_41720_();
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((ItemStack)stack);
                return bitInventory.getMaxExtractAmount(blockState);
            }
            return 0;
        }).sum();
    }

    protected abstract ItemStack getItem(int var1);

    protected abstract int getInventorySize();

    @Override
    public void extract(BlockState blockState, int count) throws IllegalArgumentException {
        ItemStack stack;
        int i;
        if (!this.canExtract(blockState, count)) {
            throw new IllegalArgumentException("Can not extract: " + blockState);
        }
        int toExtract = count;
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            stack = this.getItem(i);
            if (!(stack.m_41720_() instanceof IBitInventoryItem)) continue;
            IBitInventoryItem bitInventoryItem = (IBitInventoryItem)stack.m_41720_();
            IBitInventoryItemStack bitInventory = bitInventoryItem.create(stack);
            int inventoryExtractCount = Math.min(toExtract, bitInventory.getMaxExtractAmount(blockState));
            toExtract -= inventoryExtractCount;
            bitInventory.extract(blockState, inventoryExtractCount);
            ItemStack newStack = bitInventory.toItemStack();
            this.setSlotContents(i, newStack);
        }
        if (toExtract <= 0) {
            return;
        }
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            IBitItem bitItem;
            stack = this.getItem(i);
            if (!(stack.m_41720_() instanceof IBitItem) || (bitItem = (IBitItem)stack.m_41720_()).getBitState(stack) != blockState) continue;
            int stackExtractCount = Math.min(toExtract, stack.m_41613_());
            toExtract -= stackExtractCount;
            stack.m_41764_(stack.m_41613_() - stackExtractCount);
            this.setSlotContents(i, stack);
        }
    }

    protected abstract void setSlotContents(int var1, ItemStack var2);

    @Override
    public boolean canInsert(BlockState blockState, int count) {
        int insertionCount = this.getMaxInsertAmount(blockState);
        return count <= insertionCount;
    }

    protected int getMaxBitsForSlot() {
        return IBitItemManager.getInstance().getMaxStackSize();
    }

    @Override
    public int getMaxInsertAmount(BlockState blockState) {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::getItem).filter(stack -> stack.m_41720_() instanceof IBitItem || stack.m_41720_() instanceof IBitInventoryItem || stack.m_41619_()).mapToInt(stack -> {
            if (stack.m_41619_()) {
                return this.getMaxBitsForSlot();
            }
            if (stack.m_41720_() instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)stack.m_41720_();
                if (bitItem.getBitState((ItemStack)stack) == blockState) {
                    return this.getMaxBitsForSlot() - stack.m_41613_();
                }
                return 0;
            }
            if (stack.m_41720_() instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)stack.m_41720_();
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((ItemStack)stack);
                return bitInventory.getMaxInsertAmount(blockState);
            }
            return 0;
        }).sum();
    }

    @Override
    public void insert(BlockState blockState, int count) throws IllegalArgumentException {
        int i;
        ItemStack newStack;
        int stackInsertCount;
        ItemStack stack;
        if (!this.canInsert(blockState, count)) {
            throw new IllegalArgumentException("Can not insert: " + blockState);
        }
        int currentRawCount = 0;
        for (int i2 = 0; i2 < this.getInventorySize(); ++i2) {
            IBitItem bitItem;
            ItemStack stack2 = this.getItem(i2);
            if (!(stack2.m_41720_() instanceof IBitItem) || (bitItem = (IBitItem)stack2.m_41720_()).getBitState(stack2) != blockState) continue;
            currentRawCount += stack2.m_41613_();
        }
        int toInsert = count;
        if (currentRawCount == 0) {
            for (int i3 = 0; i3 < this.getInventorySize(); ++i3) {
                stack = this.getItem(i3);
                if (stack.m_41619_() && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot())) > 0) {
                    toInsert -= stackInsertCount;
                    newStack = IBitItemManager.getInstance().create(blockState, stackInsertCount);
                    this.setSlotContents(i3, newStack);
                    break;
                }
                if (toInsert > 0) continue;
                return;
            }
        }
        if (currentRawCount < this.getMaxBitsForSlot()) {
            for (int i4 = 0; i4 < this.getInventorySize(); ++i4) {
                int stackInsertCount2;
                IBitItem bitItem;
                stack = this.getItem(i4);
                if (stack.m_41720_() instanceof IBitItem && (bitItem = (IBitItem)stack.m_41720_()).getBitState(stack) == blockState && (stackInsertCount2 = Math.min(toInsert, this.getMaxBitsForSlot() - stack.m_41613_())) > 0) {
                    toInsert -= stackInsertCount2;
                    stack.m_41764_(stack.m_41613_() + stackInsertCount2);
                    this.setSlotContents(i4, stack);
                }
                if (toInsert > 0) continue;
                return;
            }
        }
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            IBitInventoryItem bitInventoryItem;
            IBitInventoryItemStack bitInventory;
            int inventoryInsertCount;
            stack = this.getItem(i);
            if (stack.m_41720_() instanceof IBitInventoryItem && (inventoryInsertCount = Math.min(toInsert, (bitInventory = (bitInventoryItem = (IBitInventoryItem)stack.m_41720_()).create(stack)).getMaxInsertAmount(blockState))) > 0) {
                toInsert -= inventoryInsertCount;
                bitInventory.insert(blockState, inventoryInsertCount);
                ItemStack newStack2 = bitInventory.toItemStack();
                this.setSlotContents(i, newStack2);
            }
            if (toInsert > 0) continue;
            return;
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            int stackInsertCount3;
            IBitItem bitItem;
            stack = this.getItem(i);
            if (stack.m_41720_() instanceof IBitItem && (bitItem = (IBitItem)stack.m_41720_()).getBitState(stack) == blockState && (stackInsertCount3 = Math.min(toInsert, this.getMaxBitsForSlot() - stack.m_41613_())) > 0) {
                toInsert -= stackInsertCount3;
                stack.m_41764_(stack.m_41613_() + stackInsertCount3);
                this.setSlotContents(i, stack);
            }
            if (toInsert > 0) continue;
            return;
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            stack = this.getItem(i);
            if (stack.m_41619_() && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot())) > 0) {
                toInsert -= stackInsertCount;
                newStack = IBitItemManager.getInstance().create(blockState, stackInsertCount);
                this.setSlotContents(i, newStack);
            }
            if (toInsert > 0) continue;
            return;
        }
    }

    @Override
    public Map<BlockState, Integer> getContainedStates() {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::getItem).filter(stack -> stack.m_41720_() instanceof IBitItem || stack.m_41720_() instanceof IBitInventoryItem).map(stack -> {
            if (stack.m_41720_() instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)stack.m_41720_();
                return Maps.newHashMap((Map)ImmutableMap.of((Object)bitItem.getBitState((ItemStack)stack), (Object)stack.m_41613_()));
            }
            if (stack.m_41720_() instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)stack.m_41720_();
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((ItemStack)stack);
                return Maps.newHashMap(bitInventory.getContainedStates());
            }
            return Maps.newHashMap((Map)ImmutableMap.of());
        }).reduce(Maps.newHashMap(), (blockStateIntegerHashMap, blockStateIntegerHashMap2) -> {
            HashMap result = Maps.newHashMap((Map)blockStateIntegerHashMap);
            blockStateIntegerHashMap2.forEach((state, count) -> {
                if (!result.containsKey(state)) {
                    result.put(state, count);
                } else {
                    result.put(state, (Integer)result.get(state) + count);
                }
            });
            return result;
        });
    }
}

