/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.logic;

import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.click.IRightClickControllingItem;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class RightClickInteractionHandler {
    public static ClickProcessingState rightClickOnBlock(Level level, Player player, InteractionHand hand, ItemStack itemStack, BlockPos position, Direction hitFace, boolean currentCancellationState, ClickProcessingState.ProcessingResult currentItemUsageState) {
        if (level.m_8055_(position).m_60734_() == ModBlocks.BIT_STORAGE.get()) {
            return ClickProcessingState.ALLOW_NO_CANCEL;
        }
        if (itemStack.m_41720_() instanceof IRightClickControllingItem) {
            try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Right click processing");){
                IRightClickControllingItem rightClickControllingItem = (IRightClickControllingItem)itemStack.m_41720_();
                if (!rightClickControllingItem.canUse(player)) {
                    ClickProcessingState clickProcessingState = ClickProcessingState.DENIED;
                    return clickProcessingState;
                }
                ClickProcessingState clickProcessingState = rightClickControllingItem.handleRightClickProcessing(player, hand, position, hitFace, new ClickProcessingState(currentCancellationState, currentItemUsageState));
                return clickProcessingState;
            }
        }
        return ClickProcessingState.DEFAULT;
    }

    public static ClickProcessingState rightClickOnItem(Level level, Player player, InteractionHand interactionHand, ItemStack itemStack, boolean currentCancellationState, ClickProcessingState.ProcessingResult currentItemUsageState) {
        BlockHitResult blockHitResult;
        HitResult rayTrace = RayTracingUtils.rayTracePlayer(player);
        if (rayTrace instanceof BlockHitResult && level.m_8055_((blockHitResult = (BlockHitResult)rayTrace).m_82425_()).m_60734_() == ModBlocks.BIT_STORAGE.get()) {
            return ClickProcessingState.ALLOW_NO_CANCEL;
        }
        if (itemStack.m_41720_() instanceof IRightClickControllingItem) {
            try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Right click processing");){
                IRightClickControllingItem rightClickControllingItem = (IRightClickControllingItem)itemStack.m_41720_();
                if (!rightClickControllingItem.canUse(player)) {
                    ClickProcessingState clickProcessingState = ClickProcessingState.DENIED;
                    return clickProcessingState;
                }
                ClickProcessingState clickProcessingState = rightClickControllingItem.handleRightClickProcessing(player, interactionHand, rayTrace instanceof BlockHitResult ? ((BlockHitResult)rayTrace).m_82425_() : new BlockPos(0, -1000, 0), rayTrace instanceof BlockHitResult ? ((BlockHitResult)rayTrace).m_82434_() : Direction.UP, new ClickProcessingState(currentCancellationState, currentItemUsageState));
                return clickProcessingState;
            }
        }
        return ClickProcessingState.DEFAULT;
    }
}

