/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.snapshot;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.IArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.item.ChiseledBlockItem;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.NotImplementedException;

public class LazilyDecodingSingleBlockMultiStateSnapshot
implements IMultiStateSnapshot {
    private final IStateEntryStorage lazyChunkSection = new SimpleStateEntryStorage();
    private Tag lazyNbtCompound;
    private boolean loaded = false;
    private IMultiStateObjectStatistics stateObjectStatistics = null;

    public LazilyDecodingSingleBlockMultiStateSnapshot(Tag lazyNbtCompound) {
        this.lazyNbtCompound = lazyNbtCompound;
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        this.load();
        return new Identifier(this.lazyChunkSection);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        this.load();
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.lazyChunkSection.getBlockState(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(Vec3 inAreaTarget) {
        return !(inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        this.load();
        BlockState currentState = this.lazyChunkSection.getBlockState(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        return currentState.m_60795_() ? Optional.empty() : Optional.of(new StateEntry(currentState, (Vec3i)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        if (!this.loaded) {
            Tag copyNbtCompound = this.lazyNbtCompound.m_6426_();
            return new LazilyDecodingSingleBlockMultiStateSnapshot(copyNbtCompound);
        }
        return MultiStateSnapshotUtils.createFromStorage(this.lazyChunkSection);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        this.load();
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new StateEntry(this.lazyChunkSection.getBlockState(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        this.load();
        BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
            Vec3i target = positionMutator.mutate((Vec3i)blockPos);
            consumer.accept(new StateEntry(this.lazyChunkSection.getBlockState(target.m_123341_(), target.m_123342_(), target.m_123343_()), target, this::setInAreaTarget, this::clearInAreaTarget));
        });
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        Tag tag = this.lazyNbtCompound;
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.lazyChunkSection.deserializeNBT(compoundTag);
            this.loaded = true;
        }
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        this.load();
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.lazyChunkSection.getBlockState(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(BlockState blockState, Vec3 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        this.load();
        BlockState currentState = this.lazyChunkSection.getBlockState(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        if (!currentState.m_60795_()) {
            throw new SpaceOccupiedException();
        }
        this.lazyChunkSection.setBlockState(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_(), blockState);
    }

    @Override
    public void setInBlockTarget(BlockState blockState, BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockState, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vec3 inAreaTarget) {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        this.load();
        BlockState blockState = Blocks.f_50016_.m_49966_();
        this.lazyChunkSection.setBlockState(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_(), blockState);
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateItemStack toItemStack() {
        this.load();
        BlockState primaryState = this.determinePrimaryState();
        Material blockMaterial = primaryState.m_60767_();
        Material conversionMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(blockMaterial);
        Supplier convertedItemProvider = ModItems.MATERIAL_TO_ITEM_CONVERSIONS.getOrDefault(conversionMaterial, ModItems.MATERIAL_TO_ITEM_CONVERSIONS.get(Material.f_76278_));
        ChiseledBlockItem chiseledBlockItem = (ChiseledBlockItem)convertedItemProvider.get();
        return new SingleBlockMultiStateItemStack((Item)chiseledBlockItem, this.lazyChunkSection.createSnapshot());
    }

    @Override
    public IMultiStateObjectStatistics getStatics() {
        this.load();
        this.buildStatistics();
        return this.stateObjectStatistics;
    }

    private void buildStatistics() {
        this.stateObjectStatistics = new IMultiStateObjectStatistics(){

            @Override
            public CompoundTag serializeNBT() {
                return new CompoundTag();
            }

            @Override
            public void deserializeNBT(CompoundTag nbt) {
            }

            @Override
            public BlockState getPrimaryState() {
                return LazilyDecodingSingleBlockMultiStateSnapshot.this.determinePrimaryState();
            }

            @Override
            public Map<BlockState, Integer> getStateCounts() {
                return LazilyDecodingSingleBlockMultiStateSnapshot.this.stream().collect(Collectors.toMap(IStateEntryInfo::getState, s -> 1, Integer::sum));
            }

            @Override
            public boolean shouldCheckWeakPower() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getFullnessFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getSlipperiness() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightEmissionFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightBlockingFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getRelativeBlockHardness(Player player) {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canPropagateSkylight() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canSustainGrassBelow() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public BitSet getCollideableEntries(CollisionType collisionType) {
                return BitSet.valueOf(new long[0]);
            }

            @Override
            public boolean isEmpty() {
                return !LazilyDecodingSingleBlockMultiStateSnapshot.this.determinePrimaryState().m_60795_();
            }
        };
    }

    private BlockState determinePrimaryState() {
        HashMap countMap = Maps.newHashMap();
        this.load();
        this.lazyChunkSection.count(countMap::put);
        BlockState maxState = Blocks.f_50016_.m_49966_();
        int maxCount = 0;
        for (Map.Entry blockStateIntegerEntry : countMap.entrySet()) {
            if (maxCount >= (Integer)blockStateIntegerEntry.getValue() || ((BlockState)blockStateIntegerEntry.getKey()).m_60795_()) continue;
            maxState = (BlockState)blockStateIntegerEntry.getKey();
            maxCount = (Integer)blockStateIntegerEntry.getValue();
        }
        return maxState;
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        this.load();
        this.lazyChunkSection.rotate(axis, rotationCount);
        this.lazyNbtCompound = this.lazyChunkSection.serializeNBT();
        this.buildStatistics();
    }

    @Override
    public void mirror(Direction.Axis axis) {
        this.load();
        this.lazyChunkSection.mirror(axis);
        this.lazyNbtCompound = this.lazyChunkSection.serializeNBT();
        this.buildStatistics();
    }

    @Override
    public IMultiStateSnapshot clone() {
        this.load();
        return new LazilyDecodingSingleBlockMultiStateSnapshot((Tag)this.lazyChunkSection.serializeNBT());
    }

    private static class Identifier
    implements IArrayBackedAreaShapeIdentifier {
        private final IStateEntryStorage snapshot;

        private Identifier(IStateEntryStorage section) {
            this.snapshot = section.createSnapshot();
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            IArrayBackedAreaShapeIdentifier that = (IArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.getBackingData(), that.getBackingData()) && that.getPalette().equals(this.getPalette());
        }

        @Override
        public byte[] getBackingData() {
            return this.snapshot.getRawData();
        }

        @Override
        public List<BlockState> getPalette() {
            return this.snapshot.getContainedPalette();
        }
    }

    private static class StateEntry
    implements IMutableStateEntryInfo {
        private final BlockState blockState;
        private final Vec3 startPoint;
        private final Vec3 endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        private StateEntry(BlockState blockState, Vec3i startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.blockState = blockState;
            this.startPoint = Vec3.m_82528_((Vec3i)startPoint).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.endPoint = Vec3.m_82528_((Vec3i)startPoint).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).m_82520_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        public BlockState getState() {
            return this.blockState;
        }

        @Override
        public Vec3 getStartPoint() {
            return this.startPoint;
        }

        @Override
        public Vec3 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void setState(BlockState blockState) throws SpaceOccupiedException {
            this.stateSetter.accept(blockState, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }
    }
}

