/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.platforms.core.entity.IPlayerInventoryManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BitInventoryUtils {
    private BitInventoryUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: BitInventoryUtils. This is a utility class");
    }

    public static void insertIntoOrSpawn(Player playerEntity, BlockState blockState, int count) {
        int leftOverCount;
        if (playerEntity == null || playerEntity.m_20193_().m_5776_() || count <= 0) {
            return;
        }
        IBitInventory inventory = IBitInventoryManager.getInstance().create(playerEntity);
        if (playerEntity.m_7500_()) {
            if (inventory.canExtractOne(blockState)) {
                return;
            }
            if (inventory.canInsertOne(blockState)) {
                inventory.insertOne(blockState);
            }
            return;
        }
        int maxInsertionCount = inventory.getMaxInsertAmount(blockState);
        int insertionCount = Math.min(maxInsertionCount, count);
        inventory.insert(blockState, insertionCount);
        if (leftOverCount <= 0) {
            return;
        }
        if (!IServerConfiguration.getInstance().getDeleteExcessBits().get().booleanValue()) {
            int spawnCount;
            for (leftOverCount = count - insertionCount; leftOverCount > 0 && (spawnCount = Math.min(IBitItemManager.getInstance().getMaxStackSize(), leftOverCount)) > 0; leftOverCount -= spawnCount) {
                ItemStack spawnStack = IBitItemManager.getInstance().create(blockState, spawnCount);
                IPlayerInventoryManager.getInstance().giveToPlayer(playerEntity, spawnStack);
            }
        }
    }
}

