/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.click.ILeftClickControllingItem;
import mod.chiselsandbits.api.item.click.IRightClickControllingItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.withhighlight.IWithHighlightItem;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackUtils {
    private ItemStackUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ItemStackUtils. This is a utility class");
    }

    public static ItemStack getItemStackFromBlockState(@NotNull BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return new ItemStack((ItemLike)liquidBlock.m_5888_(blockState).m_76152_().m_6859_());
        }
        Item item = ItemStackUtils.getItem(blockState);
        if (item != Items.f_41852_ && item != null) {
            return new ItemStack((ItemLike)item, 1);
        }
        return new ItemStack((ItemLike)blockState.m_60734_(), 1);
    }

    public static Item getItem(@NotNull BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block.equals(Blocks.f_49991_)) {
            return Items.f_42448_;
        }
        if (block instanceof CropBlock) {
            ItemStack stack = ((CropBlock)block).m_7397_((BlockGetter)new SingleBlockBlockReader(blockState), BlockPos.f_121853_, blockState);
            if (!stack.m_41619_()) {
                return stack.m_41720_();
            }
            return Items.f_42404_;
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return Blocks.f_50493_.m_5456_();
        }
        if (block instanceof FireBlock) {
            return Items.f_42409_;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.f_42618_;
        }
        if (block == Blocks.f_50570_) {
            return Items.f_41911_;
        }
        return block.m_5456_();
    }

    public static ItemStack getModeItemStackFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return ItemStack.f_41583_;
        }
        if (playerEntity.m_21205_().m_41720_() instanceof IWithModeItem) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IWithModeItem) {
            return playerEntity.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getHighlightItemStackFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return ItemStack.f_41583_;
        }
        if (playerEntity.m_21205_().m_41720_() instanceof IWithHighlightItem) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IWithHighlightItem) {
            return playerEntity.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getMultiStateItemStackFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return ItemStack.f_41583_;
        }
        if (playerEntity.m_21205_().m_41720_() instanceof IMultiStateItem) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IMultiStateItem) {
            return playerEntity.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getPatternItemStackFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return ItemStack.f_41583_;
        }
        if (playerEntity.m_21205_().m_41720_() instanceof IPatternItem) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IPatternItem) {
            return playerEntity.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static InteractionHand getPatternHandFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return InteractionHand.MAIN_HAND;
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IPatternItem) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    public static ItemStack getBitItemStackFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return ItemStack.f_41583_;
        }
        if (playerEntity.m_21205_().m_41720_() instanceof IBitItem) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IBitItem) {
            return playerEntity.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getLeftClickControllingItemStackFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return ItemStack.f_41583_;
        }
        if (playerEntity.m_21205_().m_41720_() instanceof ILeftClickControllingItem) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() instanceof ILeftClickControllingItem) {
            return playerEntity.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getRightClickControllingItemStackFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return ItemStack.f_41583_;
        }
        if (playerEntity.m_21205_().m_41720_() instanceof IRightClickControllingItem) {
            return playerEntity.m_21205_();
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IRightClickControllingItem) {
            return playerEntity.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    public static BlockState getHeldBitBlockStateFromPlayer(@Nullable Player playerEntity) {
        if (playerEntity == null) {
            return Blocks.f_50016_.m_49966_();
        }
        if (playerEntity.m_21205_().m_41720_() instanceof IBitItem) {
            return ((IBitItem)playerEntity.m_21205_().m_41720_()).getBitState(playerEntity.m_21205_());
        }
        if (playerEntity.m_21206_().m_41720_() instanceof IBitItem) {
            return ((IBitItem)playerEntity.m_21206_().m_41720_()).getBitState(playerEntity.m_21206_());
        }
        return Blocks.f_50016_.m_49966_();
    }

    public static BlockState getStateFromItem(ItemStack is) {
        try {
            if (!is.m_41619_() && is.m_41720_() instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)is.m_41720_();
                return blockItem.m_40614_().m_49966_();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Blocks.f_50016_.m_49966_();
    }
}

