/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.mysticalagriculture.api.util.ExperienceCapsuleUtils;
import com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem;
import com.blakebr0.mysticalagriculture.network.NetworkHandler;
import com.blakebr0.mysticalagriculture.network.message.ExperienceCapsulePickupMessage;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public final class ExperienceCapsuleHandler {
    @SubscribeEvent
    public void onPlayerPickupXp(PlayerXpEvent.PickupXp event) {
        List<ItemStack> capsules;
        ExperienceOrb orb = event.getOrb();
        Player player = event.getPlayer();
        if (player != null && !(capsules = ExperienceCapsuleHandler.getExperienceCapsules(player)).isEmpty()) {
            for (ItemStack stack : capsules) {
                int remaining;
                orb.f_20770_ = remaining = ExperienceCapsuleUtils.addExperienceToCapsule(stack, orb.m_20801_());
                if (remaining != 0) continue;
                orb.m_146870_();
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ExperienceCapsulePickupMessage());
                event.setCanceled(true);
                return;
            }
        }
    }

    private static List<ItemStack> getExperienceCapsules(Player player) {
        return player.m_150109_().f_35974_.stream().filter(s -> s.m_41720_() instanceof ExperienceCapsuleItem).collect(Collectors.toList());
    }
}

