/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulJarItem
extends BaseItem {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public SoulJarItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.m_41487_(1)));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)new ItemStack((ItemLike)this));
            MobSoulTypeRegistry.getInstance().getMobSoulTypes().forEach(type -> {
                if (type.isEnabled()) {
                    items.add((Object)MobSoulUtils.getFilledSoulJar(type, (Item)this));
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        MobSoulType type = MobSoulUtils.getType(stack);
        if (type != null) {
            Component entityName = type.getEntityDisplayName();
            String souls = DECIMAL_FORMAT.format(MobSoulUtils.getSouls(stack));
            String requirement = DECIMAL_FORMAT.format(type.getSoulRequirement());
            tooltip.add((Component)ModTooltips.SOUL_JAR.args(new Object[]{entityName, souls, requirement}).build());
            if (flag.m_7050_()) {
                tooltip.add((Component)ModTooltips.MST_ID.args(new Object[]{type.getId()}).color(ChatFormatting.DARK_GRAY).build());
            }
        }
    }

    public static ItemPropertyFunction getFillPropertyGetter() {
        return (stack, world, entity, _unused) -> {
            double souls;
            MobSoulType type = MobSoulUtils.getType(stack);
            if (type != null && (souls = MobSoulUtils.getSouls(stack)) > 0.0) {
                return (int)(souls / type.getSoulRequirement() * 9.0);
            }
            return 0.0f;
        };
    }
}

