/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.client.gui.components.IconButton;
import fuzs.enchantinginfuser.network.client.message.C2SAddEnchantLevelMessage;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.network.message.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InfuserScreen
extends AbstractContainerScreen<InfuserMenu> {
    private static final ResourceLocation INFUSER_LOCATION = new ResourceLocation("enchantinginfuser", "textures/gui/container/enchanting_infuser.png");
    private final int enchantmentSeed = new Random().nextInt();
    private List<FormattedCharSequence> activeTooltip;
    private float scrollOffs;
    private boolean scrolling;
    private EditBox searchBox;
    private ScrollingList scrollingList;
    private boolean ignoreTextInput;
    private Button enchantButton;

    public InfuserScreen(InfuserMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 220;
        this.f_97727_ = 185;
        this.f_97730_ = 30;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public void m_181908_() {
        super.m_181908_();
        this.searchBox.m_94120_();
        this.updateButtons();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 67, this.f_97736_ + 6, 116, 9, (Component)new TranslatableComponent("itemGroup.search")){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.m_94213_() && button == 1) {
                    this.m_94144_("");
                    InfuserScreen.this.refreshSearchResults();
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.scrollingList = new ScrollingList(this.f_97735_ + 29, this.f_97736_ + 17, 162, 18, 4);
        this.m_7787_((GuiEventListener)this.scrollingList);
        this.enchantButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 7, this.f_97736_ + 55, 18, 18, 126, 185, INFUSER_LOCATION, button -> {
            if (((InfuserMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 0)) {
                this.f_96541_.f_91072_.m_105208_(((InfuserMenu)this.f_97732_).f_38840_, 0);
            }
            this.searchBox.m_94144_("");
        }));
        this.updateButtons();
    }

    private void updateButtons() {
        this.enchantButton.f_93623_ = ((InfuserMenu)this.f_97732_).canEnchant((Player)this.f_96541_.f_91074_);
    }

    public void setActiveTooltip(List<FormattedCharSequence> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.searchBox.m_94155_();
        super.m_6574_(pMinecraft, pWidth, pHeight);
        this.searchBox.m_94144_(s);
        this.refreshSearchResults();
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (!this.searchBox.m_93696_()) {
            if (this.f_96541_.f_91066_.f_92098_.m_90832_(pKeyCode, pScanCode)) {
                this.ignoreTextInput = true;
                this.searchBox.m_94178_(true);
                return true;
            }
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        boolean flag = this.f_97734_ != null && this.f_97734_.m_6657_();
        boolean flag1 = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode).m_84876_().isPresent();
        if (flag && flag1 && this.m_97805_(pKeyCode, pScanCode)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && pKeyCode != 256 || super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public void refreshSearchResults() {
        this.scrollingList.clearEntries();
        String s = this.searchBox.m_94155_().toLowerCase(Locale.ROOT).trim();
        if (s.isEmpty()) {
            ((InfuserMenu)this.f_97732_).getSortedEntries().stream().map(e -> new EnchantmentListEntry((Enchantment)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        } else {
            ((InfuserMenu)this.f_97732_).getSortedEntries().stream().filter(e -> new TranslatableComponent(((Enchantment)e.getKey()).m_44704_()).getString().toLowerCase(Locale.ROOT).contains(s)).filter(e -> (Integer)((InfuserMenu)this.f_97732_).getMaxLevel((Enchantment)e.getKey()).getSecond() > 0).map(e -> new EnchantmentListEntry((Enchantment)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        }
        this.scrollOffs = 0.0f;
        this.scrollingList.scrollTo(0.0f);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.insideScrollbar(pMouseX, pMouseY)) {
            this.scrolling = this.scrollingList.canScroll();
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected boolean insideScrollbar(double pMouseX, double pMouseY) {
        int fromX = this.f_97735_ + 197;
        int fromY = this.f_97736_ + 17;
        int toX = fromX + 14;
        int toY = fromY + 72;
        return pMouseX >= (double)fromX && pMouseY >= (double)fromY && pMouseX < (double)toX && pMouseY < (double)toY;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (!this.scrollingList.canScroll()) {
            return false;
        }
        this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)(this.scrollingList.getItemCount() - 4));
        this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
        this.scrollingList.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            int i = this.f_97736_ + 17;
            int j = i + 72;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.scrollingList.scrollTo(this.scrollOffs);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.activeTooltip = null;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.scrollingList.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.renderEnchantingPower(poseStack, mouseX, mouseY);
        this.renderEnchantingCost(poseStack, mouseX, mouseY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.activeTooltip != null) {
            this.m_96617_(poseStack, this.activeTooltip, mouseX, mouseY);
        } else {
            this.m_7025_(poseStack, mouseX, mouseY);
        }
    }

    private void renderEnchantingCost(PoseStack poseStack, int mouseX, int mouseY) {
        int cost = ((InfuserMenu)this.f_97732_).getCost();
        if (cost <= 0) {
            return;
        }
        boolean canEnchant = ((InfuserMenu)this.f_97732_).canEnchant((Player)this.f_96541_.f_91074_);
        int costColor = canEnchant ? 8453920 : 0xFF5555;
        int posX = this.f_97735_ + 7;
        int posY = this.f_97736_ + 55;
        this.renderReadableText(poseStack, posX + 1, posY + 1, String.valueOf(cost), costColor);
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 18 && mouseY < posY + 18) {
            ArrayList list = Lists.newArrayList();
            if (canEnchant) {
                ((InfuserMenu)this.f_97732_).getValidEnchantments().map(e -> ((Enchantment)e.getKey()).m_44700_(((Integer)e.getValue()).intValue())).forEach(list::add);
                list.add(TextComponent.f_131282_);
                TranslatableComponent mutablecomponent1 = cost == 1 ? new TranslatableComponent("container.enchant.level.one") : new TranslatableComponent("container.enchant.level.many", new Object[]{cost});
                list.add(mutablecomponent1.m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(new TranslatableComponent("container.enchant.level.requirement", new Object[]{cost}).m_130940_(ChatFormatting.RED));
            }
            this.setActiveTooltip(Language.m_128107_().m_128112_((List)list));
        }
    }

    private void renderReadableText(PoseStack poseStack, int posX, int posY, String text, int color) {
        this.f_96547_.m_92883_(poseStack, text, (float)((posX += 17 - this.f_96547_.m_92895_(text)) - 1), (float)(posY += 9), 0);
        this.f_96547_.m_92883_(poseStack, text, (float)(posX + 1), (float)posY, 0);
        this.f_96547_.m_92883_(poseStack, text, (float)posX, (float)(posY - 1), 0);
        this.f_96547_.m_92883_(poseStack, text, (float)posX, (float)(posY + 1), 0);
        this.f_96547_.m_92883_(poseStack, text, (float)posX, (float)posY, color);
    }

    private void renderEnchantingPower(PoseStack poseStack, int mouseX, int mouseY) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_41997_);
        this.f_96542_.f_115093_ = 100.0f;
        int posX = this.f_97735_ + 196;
        int posY = this.f_97736_ + 161;
        this.f_96542_.m_115218_(itemstack, posX, posY);
        String power = String.valueOf(((InfuserMenu)this.f_97732_).getCurrentPower());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 300.0);
        this.f_96547_.m_92750_(poseStack, power, (float)(posX + 19 - 2 - this.f_96547_.m_92895_(power)), (float)(posY + 6 + 3), 0xFFFFFF);
        poseStack.m_85849_();
        this.f_96542_.f_115093_ = 0.0f;
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 16) {
            this.setActiveTooltip(Lists.newArrayList((Object[])new FormattedCharSequence[]{new TranslatableComponent("gui.enchantinginfuser.tooltip.enchanting_power", new Object[]{power}).m_130940_(ChatFormatting.YELLOW).m_7532_()}));
        }
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)INFUSER_LOCATION);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(pPoseStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        this.searchBox.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)INFUSER_LOCATION);
        int sliderX = this.f_97735_ + 197 - 2;
        int sliderY = this.f_97736_ + 17 - 2;
        int sliderRange = sliderY + 72 + 2 + 2;
        this.m_93228_(pPoseStack, sliderX, sliderY + (int)((float)(sliderRange - sliderY - 18) * this.scrollOffs), 220, 54 + (this.scrollingList.canScroll() ? 18 : 0), 18, 18);
    }

    private class ScrollingList
    extends AbstractContainerEventHandler
    implements Widget,
    NarratableEntry {
        private final List<EnchantmentListEntry> children = Lists.newArrayList();
        private final int posX;
        private final int posY;
        private final int itemWidth;
        private final int itemHeight;
        private final int length;
        private int scrollPosition;

        public ScrollingList(int posX, int posY, int itemWidth, int itemHeight, int length) {
            this.posX = posX;
            this.posY = posY;
            this.itemWidth = itemWidth;
            this.itemHeight = itemHeight;
            this.length = length;
        }

        public void scrollTo(float pos) {
            if (pos < 0.0f || pos > 1.0f) {
                throw new IllegalArgumentException("pos must be of interval 0 to 1");
            }
            this.scrollPosition = this.canScroll() ? Math.round((float)(this.getItemCount() - this.length) * pos) : 0;
        }

        public boolean canScroll() {
            return this.getItemCount() > this.length;
        }

        protected final void clearEntries() {
            this.children.clear();
        }

        protected void addEntry(EnchantmentListEntry pEntry) {
            this.children.add(pEntry);
            pEntry.setList(this);
            this.markOthersIncompatible();
        }

        protected int getItemCount() {
            return this.children.size();
        }

        public void markOthersIncompatible() {
            List<EnchantmentListEntry> activeEnchants = this.children.stream().filter(EnchantmentListEntry::isActive).toList();
            for (EnchantmentListEntry entry : this.children) {
                if (entry.isActive()) continue;
                entry.markIncompatible(activeEnchants.stream().filter(e -> e.isIncompatibleWith(entry)).collect(Collectors.toSet()));
            }
        }

        @Nullable
        protected final EnchantmentListEntry getEntryAtPosition(double mouseX, double mouseY) {
            if (this.m_5953_(mouseX, mouseY)) {
                int index = this.scrollPosition + (int)((mouseY - (double)this.posY) / (double)this.itemHeight);
                return index < this.children.size() ? this.children.get(index) : null;
            }
            return null;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return mouseX >= (double)this.posX && mouseX < (double)(this.posX + this.itemWidth) && mouseY >= (double)this.posY && mouseY < (double)(this.posY + this.itemHeight * this.length);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            EnchantmentListEntry entry = this.getEntryAtPosition(mouseX, mouseY);
            if (entry != null && entry.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)entry);
                this.m_7897_(true);
                return true;
            }
            return false;
        }

        public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
            if (this.m_7222_() != null) {
                this.m_7222_().m_6348_(pMouseX, pMouseY, pButton);
            }
            return false;
        }

        public List<EnchantmentListEntry> m_6702_() {
            return this.children;
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            for (int i = 0; i < Math.min(this.length, this.getItemCount()); ++i) {
                this.children.get(this.scrollPosition + i).render(poseStack, this.posX, this.posY + this.itemHeight * i, this.itemWidth, this.itemHeight, mouseX, mouseY, partialTick);
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    private class EnchantmentListEntry
    implements ContainerEventHandler {
        private static final Component UNKNOWN_ENCHANT_COMPONENT = new TranslatableComponent("gui.enchantinginfuser.tooltip.unknown_enchantment").m_130940_(ChatFormatting.GRAY);
        private static final Component LOW_POWER_COMPONENT = new TranslatableComponent("gui.enchantinginfuser.tooltip.low_power").m_130940_(ChatFormatting.GRAY);
        private final Enchantment enchantment;
        private final int maxLevel;
        private final int requiredPower;
        private final Button decrButton;
        private final Button incrButton;
        private int level;
        private ScrollingList list;
        @Nullable
        private GuiEventListener focused;
        private boolean dragging;
        private Set<Enchantment> incompatible = Sets.newHashSet();

        public EnchantmentListEntry(Enchantment enchantment, int level) {
            this.enchantment = enchantment;
            Pair<Optional<Integer>, Integer> maxLevelResult = ((InfuserMenu)InfuserScreen.this.f_97732_).getMaxLevel(enchantment);
            this.maxLevel = (Integer)maxLevelResult.getSecond();
            this.requiredPower = ((Optional)maxLevelResult.getFirst()).orElse(-1);
            this.level = level;
            this.decrButton = new IconButton(0, 0, 18, 18, 220, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.f_97732_).clickEnchantmentButton(this.enchantment, false)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((Message)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).f_97732_).f_38840_, this.enchantment, false));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.f_93623_ && button.f_93624_ && Screen.m_96638_());
            }){

                @Override
                public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
                    if (this.f_93623_ && Screen.m_96638_()) {
                        RenderSystem.m_69482_();
                        RenderSystem.m_157427_(GameRenderer::m_172817_);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                        int index = this.m_7202_(this.m_198029_());
                        1.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + 2), (int)this.f_93621_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.f_93618_, (int)this.f_93619_, (int)this.textureWidth, (int)this.textureHeight);
                        1.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ - 4), (int)this.f_93621_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.f_93618_, (int)this.f_93619_, (int)this.textureWidth, (int)this.textureHeight);
                        if (this.m_198029_()) {
                            this.m_7428_(poseStack, mouseX, mouseY);
                        }
                    } else {
                        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
                    }
                }
            };
            this.incrButton = new IconButton(0, 0, 18, 18, 238, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.f_97732_).clickEnchantmentButton(this.enchantment, true)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((Message)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).f_97732_).f_38840_, this.enchantment, true));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.f_93623_ && button.f_93624_ && Screen.m_96638_());
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (this.level >= this.maxLevel && !this.isObfuscated()) {
                    InfuserScreen.this.setActiveTooltip(this.getLowPowerComponent(LOW_POWER_COMPONENT));
                }
            }){

                @Override
                public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
                    if (this.f_93623_ && Screen.m_96638_()) {
                        RenderSystem.m_69482_();
                        RenderSystem.m_157427_(GameRenderer::m_172817_);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                        int index = this.m_7202_(this.m_198029_());
                        2.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ - 2), (int)this.f_93621_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.f_93618_, (int)this.f_93619_, (int)this.textureWidth, (int)this.textureHeight);
                        2.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + 4), (int)this.f_93621_, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.f_93618_, (int)this.f_93619_, (int)this.textureWidth, (int)this.textureHeight);
                        if (this.m_198029_()) {
                            this.m_7428_(poseStack, mouseX, mouseY);
                        }
                    } else {
                        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
                    }
                }
            };
            this.updateButtons();
        }

        private List<FormattedCharSequence> getLowPowerComponent(Component component) {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslatableComponent("gui.enchantinginfuser.tooltip.required_enchanting_power", new Object[]{new TextComponent(String.valueOf(((InfuserMenu)InfuserScreen.this.f_97732_).getCurrentPower())).m_130940_(ChatFormatting.RED), new TextComponent(String.valueOf(this.requiredPower))}).m_7532_());
            list.addAll(InfuserScreen.this.f_96547_.m_92923_((FormattedText)component, 175));
            return list;
        }

        public void setList(ScrollingList list) {
            this.list = list;
        }

        public void markIncompatible(Collection<EnchantmentListEntry> incompatibleList) {
            this.incompatible = incompatibleList.stream().map(e -> e.enchantment).collect(Collectors.toSet());
            boolean compatible = incompatibleList.isEmpty();
            if (!compatible) {
                this.level = 0;
            }
            this.updateButtons();
            this.decrButton.f_93623_ = compatible;
            this.incrButton.f_93623_ &= compatible;
        }

        private void updateButtons() {
            this.decrButton.f_93624_ = this.level > 0;
            this.incrButton.f_93624_ = this.level < this.enchantment.m_6586_();
            this.incrButton.f_93623_ = this.level < this.maxLevel;
        }

        public boolean isActive() {
            return this.level > 0;
        }

        public boolean isIncompatible() {
            return !this.incompatible.isEmpty();
        }

        public boolean isObfuscated() {
            return this.maxLevel == 0;
        }

        private int getYImage() {
            return this.isIncompatible() || this.isObfuscated() ? 0 : (this.isActive() ? 2 : 1);
        }

        public boolean isIncompatibleWith(EnchantmentListEntry other) {
            if (other == this) {
                return false;
            }
            return (this.isActive() || other.isActive()) && !this.enchantment.m_44695_(other.enchantment);
        }

        public void render(PoseStack poseStack, int leftPos, int topPos, int width, int height, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)INFUSER_LOCATION);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            InfuserScreen.this.m_93228_(poseStack, leftPos + 18, topPos, 0, 185 + this.getYImage() * 18, 126, 18);
            FormattedCharSequence formattedCharSequence = this.getRenderingName(this.enchantment, width);
            GuiComponent.m_168749_((PoseStack)poseStack, (Font)InfuserScreen.this.f_96547_, (FormattedCharSequence)formattedCharSequence, (int)(leftPos + width / 2), (int)(topPos + 5), (int)(this.isIncompatible() || this.isObfuscated() ? 6839882 : -1));
            if (mouseX >= leftPos + 18 && mouseX < leftPos + 18 + 126 && mouseY >= topPos && mouseY < topPos + 18) {
                this.handleTooltip(this.enchantment);
            }
            this.decrButton.f_93620_ = leftPos;
            this.decrButton.f_93621_ = topPos;
            this.decrButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.incrButton.f_93620_ = leftPos + width - 18;
            this.incrButton.f_93621_ = topPos;
            this.incrButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        private FormattedCharSequence getRenderingName(Enchantment enchantment, int maxWidth) {
            FormattedCharSequence formattedCharSequence = null;
            if (this.isObfuscated()) {
                EnchantmentNames.m_98734_().m_98735_((long)(InfuserScreen.this.enchantmentSeed + ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantment)));
                FormattedText formattedtext = EnchantmentNames.m_98734_().m_98737_(InfuserScreen.this.f_96547_, (int)((float)maxWidth * 0.72f));
                List list = InfuserScreen.this.f_96547_.m_92923_(formattedtext, (int)((float)maxWidth * 0.72f));
                if (!list.isEmpty()) {
                    formattedCharSequence = (FormattedCharSequence)list.get(0);
                }
            }
            if (formattedCharSequence == null) {
                TranslatableComponent component = new TranslatableComponent(enchantment.m_44704_());
                if (this.isActive()) {
                    component.m_130946_(" ").m_7220_((Component)new TranslatableComponent("enchantment.level." + this.level));
                }
                formattedCharSequence = component.m_7532_();
            }
            return formattedCharSequence;
        }

        private void handleTooltip(Enchantment enchantment) {
            if (this.isObfuscated()) {
                InfuserScreen.this.setActiveTooltip(this.getLowPowerComponent(UNKNOWN_ENCHANT_COMPONENT));
            } else if (this.isIncompatible()) {
                TranslatableComponent incompatibleComponent = new TranslatableComponent("gui.enchantinginfuser.tooltip.incompatible", new Object[]{this.incompatible.stream().map(e -> new TranslatableComponent(e.m_44704_())).reduce((o1, o2) -> o1.m_130946_(", ").m_7220_((Component)o2)).orElse((MutableComponent)new TextComponent("")).m_130940_(ChatFormatting.GRAY)});
                InfuserScreen.this.setActiveTooltip(InfuserScreen.this.f_96547_.m_92923_((FormattedText)incompatibleComponent, 175));
            } else {
                ArrayList list = Lists.newArrayList();
                if (Language.m_128107_().m_6722_(enchantment.m_44704_() + ".desc")) {
                    list.addAll(InfuserScreen.this.f_96547_.m_92923_((FormattedText)new TranslatableComponent(enchantment.m_44704_() + ".desc").m_130940_(ChatFormatting.GRAY), 175));
                } else if (Language.m_128107_().m_6722_(enchantment.m_44704_() + ".description")) {
                    list.addAll(InfuserScreen.this.f_96547_.m_92923_((FormattedText)new TranslatableComponent(enchantment.m_44704_() + ".description").m_130940_(ChatFormatting.GRAY), 175));
                }
                if (!list.isEmpty()) {
                    TranslatableComponent levelsComponent = new TranslatableComponent("enchantment.level." + enchantment.m_44702_());
                    if (enchantment.m_44702_() != enchantment.m_6586_()) {
                        levelsComponent.m_130946_("-").m_7220_((Component)new TranslatableComponent("enchantment.level." + enchantment.m_6586_()));
                    }
                    MutableComponent wrappedComponent = new TextComponent("(").m_7220_((Component)levelsComponent).m_130946_(")").m_130940_(ChatFormatting.GRAY);
                    list.add(0, new TranslatableComponent(enchantment.m_44704_()).m_130946_(" ").m_7220_((Component)wrappedComponent).m_7532_());
                    InfuserScreen.this.setActiveTooltip(list);
                }
            }
        }

        public boolean m_5953_(double pMouseX, double pMouseY) {
            return Objects.equals(this.list.getEntryAtPosition(pMouseX, pMouseY), this);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.decrButton, (Object)this.incrButton);
        }

        public boolean m_7282_() {
            return this.dragging;
        }

        public void m_7897_(boolean pDragging) {
            this.dragging = pDragging;
        }

        public void m_7522_(@Nullable GuiEventListener pListener) {
            this.focused = pListener;
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.focused;
        }
    }
}

