/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.network.client.message;

import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.network.message.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class C2SAddEnchantLevelMessage
implements Message {
    private int containerId;
    private Enchantment enchantment;
    private boolean increase;

    public C2SAddEnchantLevelMessage() {
    }

    public C2SAddEnchantLevelMessage(int containerId, Enchantment enchantment, boolean increase) {
        this.containerId = containerId;
        this.enchantment = enchantment;
        this.increase = increase;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.containerId);
        buf.writeInt(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)this.enchantment));
        buf.writeBoolean(this.increase);
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.readByte();
        this.enchantment = (Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buf.readInt());
        this.increase = buf.readBoolean();
    }

    public EnchantmentLevelHandler makeHandler() {
        return new EnchantmentLevelHandler();
    }

    private static class EnchantmentLevelHandler
    extends Message.PacketHandler<C2SAddEnchantLevelMessage> {
        private EnchantmentLevelHandler() {
        }

        public void handle(C2SAddEnchantLevelMessage packet, Player player, Object gameInstance) {
            AbstractContainerMenu abstractContainerMenu;
            if (player.f_36096_.f_38840_ == packet.containerId && (abstractContainerMenu = player.f_36096_) instanceof InfuserMenu) {
                InfuserMenu menu = (InfuserMenu)abstractContainerMenu;
                menu.clickEnchantmentButton(packet.enchantment, packet.increase);
            }
        }
    }
}

