/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.network.message;

import com.google.common.collect.Lists;
import fuzs.enchantinginfuser.client.gui.screens.inventory.InfuserScreen;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.network.message.Message;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class S2CCompatibleEnchantsMessage
implements Message {
    private int containerId;
    private List<Enchantment> enchantments;

    public S2CCompatibleEnchantsMessage() {
    }

    public S2CCompatibleEnchantsMessage(int containerId, List<Enchantment> enchantments) {
        this.containerId = containerId;
        this.enchantments = enchantments;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.containerId);
        buf.writeInt(this.enchantments.size());
        for (Enchantment enchantment : this.enchantments) {
            buf.writeInt(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantment));
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.readByte();
        int size = buf.readInt();
        ArrayList enchantments = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            enchantments.add((Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buf.readInt()));
        }
        this.enchantments = enchantments;
    }

    public CompatibleEnchantsHandler makeHandler() {
        return new CompatibleEnchantsHandler();
    }

    private static class CompatibleEnchantsHandler
    extends Message.PacketHandler<S2CCompatibleEnchantsMessage> {
        private CompatibleEnchantsHandler() {
        }

        public void handle(S2CCompatibleEnchantsMessage packet, Player player, Object gameInstance) {
            AbstractContainerMenu abstractContainerMenu;
            if (player.f_36096_.f_38840_ == packet.containerId && (abstractContainerMenu = player.f_36096_) instanceof InfuserMenu) {
                InfuserMenu menu = (InfuserMenu)abstractContainerMenu;
                menu.setEnchantments(packet.enchantments);
                Screen screen = ((Minecraft)gameInstance).f_91080_;
                if (screen instanceof InfuserScreen) {
                    InfuserScreen screen2 = (InfuserScreen)screen;
                    screen2.refreshSearchResults();
                }
            }
        }
    }
}

