/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.network.message.S2CCompatibleEnchantsMessage;
import fuzs.enchantinginfuser.registry.ModRegistry;
import fuzs.enchantinginfuser.world.level.block.InfuserBlock;
import fuzs.puzzleslib.network.message.Message;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InfuserMenu
extends AbstractContainerMenu
implements ContainerListener {
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final Container enchantSlots;
    private final ContainerLevelAccess levelAccess;
    private final Player player;
    private InfuserBlock.InfuserType infuserType;
    private final DataSlot enchantingPower = DataSlot.m_39401_();
    private final DataSlot enchantingCost = DataSlot.m_39401_();
    private Map<Enchantment, Integer> enchantmentsToLevel;

    public InfuserMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(1), ContainerLevelAccess.f_39287_, InfuserBlock.InfuserType.NORMAL);
    }

    public InfuserMenu(int id, final Inventory inventory, Container container, ContainerLevelAccess levelAccess, InfuserBlock.InfuserType type) {
        super((MenuType)ModRegistry.INFUSING_MENU_TYPE.get(), id);
        this.enchantSlots = container;
        this.levelAccess = levelAccess;
        this.player = inventory.f_35978_;
        this.infuserType = type;
        this.m_38897_(new Slot(container, 0, 8, 34){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41792_() || stack.m_41720_() instanceof BookItem && !this.m_6657_();
            }

            public int m_6641_() {
                return 1;
            }
        });
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = SLOT_IDS[k];
            this.m_38897_(new Slot((Container)inventory, 39 - k, 8 + 188 * (k / 2), 103 + k % 2 * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack p_39746_) {
                    return p_39746_.canEquip(equipmentslot, (Entity)inventory.f_35978_);
                }

                public boolean m_8010_(Player p_39744_) {
                    ItemStack itemstack = this.m_7993_();
                    return (itemstack.m_41619_() || p_39744_.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(p_39744_);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.m_20749_()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inventory, j1 + (l + 1) * 9, 30 + j1 * 18, 103 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inventory, i1, 30 + i1 * 18, 161));
        }
        this.m_38897_(new Slot((Container)inventory, 40, 8, 161){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.m_38895_(this.enchantingPower);
        this.m_38895_(this.enchantingCost);
        this.m_38893_(this);
    }

    public boolean m_6875_(Player pPlayer) {
        return this.enchantSlots.m_6542_(pPlayer);
    }

    public void m_6199_(Container pInventory) {
        if (pInventory == this.enchantSlots) {
            this.enchantingCost.m_6422_(0);
            ItemStack itemstack = pInventory.m_8020_(0);
            if (!itemstack.m_41619_() && itemstack.m_41792_()) {
                this.levelAccess.m_39292_((level, pos) -> {
                    this.setEnchantingPower((Level)level, (BlockPos)pos);
                    List<Enchantment> availableEnchantments = InfuserMenu.getAvailableEnchantments(itemstack, ((ServerConfig)EnchantingInfuser.CONFIG.server()).types.treasure, ((ServerConfig)EnchantingInfuser.CONFIG.server()).types.undiscoverable, ((ServerConfig)EnchantingInfuser.CONFIG.server()).types.curses);
                    this.setEnchantments(availableEnchantments);
                });
            } else {
                this.setEnchantments(List.of());
            }
        }
    }

    public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
        if (abstractContainerMenu == this) {
            this.levelAccess.m_39292_((level, pos) -> {
                if (i == 0) {
                    this.m_6199_(this.enchantSlots);
                }
            });
        }
    }

    public int setEnchantingPower(Level level, BlockPos pos) {
        int power = this.getAvailablePower(level, pos);
        this.enchantingPower.m_6422_(power);
        return power;
    }

    public void setEnchantingPower(int power) {
        this.enchantingPower.m_6422_(power);
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    private int getAvailablePower(Level world, BlockPos pos) {
        int power = 0;
        for (int k = -1; k <= 1; ++k) {
            for (int l = -1; l <= 1; ++l) {
                if (k == 0 && l == 0 || !InfuserMenu.isBlockEmpty(world, pos.m_142082_(l, 0, k)) || !InfuserMenu.isBlockEmpty(world, pos.m_142082_(l, 1, k))) continue;
                power = (int)((float)power + this.getBlockPower(world, pos.m_142082_(l * 2, 0, k * 2)));
                power = (int)((float)power + this.getBlockPower(world, pos.m_142082_(l * 2, 1, k * 2)));
                if (l == 0 || k == 0) continue;
                power = (int)((float)power + this.getBlockPower(world, pos.m_142082_(l * 2, 0, k)));
                power = (int)((float)power + this.getBlockPower(world, pos.m_142082_(l * 2, 1, k)));
                power = (int)((float)power + this.getBlockPower(world, pos.m_142082_(l, 0, k * 2)));
                power = (int)((float)power + this.getBlockPower(world, pos.m_142082_(l, 1, k * 2)));
            }
        }
        return power;
    }

    private float getBlockPower(Level world, BlockPos pos) {
        return world.m_8055_(pos).getEnchantPowerBonus((LevelReader)world, pos);
    }

    public int clickEnchantmentButton(Enchantment enchantment, boolean increase) {
        boolean incompatible = this.enchantmentsToLevel.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).filter(e -> e != enchantment).anyMatch(e -> !e.m_44695_(enchantment));
        if (incompatible) {
            EnchantingInfuser.LOGGER.warn("trying to add incompatible enchantment");
            return -1;
        }
        int level = this.enchantmentsToLevel.get(enchantment) + (increase ? 1 : -1);
        if (level != Mth.m_14045_((int)level, (int)0, (int)enchantment.m_6586_())) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond bounds");
            return -1;
        }
        if (level > (Integer)this.getMaxLevel(enchantment).getSecond()) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond max allowed level");
            return -1;
        }
        this.enchantmentsToLevel.put(enchantment, level);
        this.enchantingCost.m_6422_(this.getScaledCosts());
        return level;
    }

    public boolean m_6366_(Player player, int id) {
        if (id != 0) {
            return false;
        }
        ItemStack itemstack = this.enchantSlots.m_8020_(0);
        int cost = this.getScaledCosts();
        if (itemstack.m_41619_() || cost <= 0 || player.f_36078_ < cost && !player.m_150110_().f_35937_) {
            return false;
        }
        this.levelAccess.m_39292_((level, pos) -> {
            ItemStack itemstack2 = itemstack;
            if (!this.enchantmentsToLevel.isEmpty()) {
                player.m_7408_(itemstack, cost);
                boolean isBook = itemstack.m_41720_() instanceof BookItem;
                if (isBook) {
                    itemstack2 = new ItemStack((ItemLike)Items.f_42690_);
                    CompoundTag compoundtag = itemstack.m_41783_();
                    if (compoundtag != null) {
                        itemstack2.m_41751_(compoundtag.m_6426_());
                    }
                    this.enchantSlots.m_6836_(0, itemstack2);
                }
                for (Map.Entry<Enchantment, Integer> entry : this.enchantmentsToLevel.entrySet()) {
                    if (entry.getValue() <= 0) continue;
                    if (isBook) {
                        EnchantedBookItem.m_41153_((ItemStack)itemstack2, (EnchantmentInstance)new EnchantmentInstance(entry.getKey(), entry.getValue().intValue()));
                        continue;
                    }
                    itemstack2.m_41663_(entry.getKey(), entry.getValue().intValue());
                }
                player.m_36220_(Stats.f_12964_);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10575_.m_27668_((ServerPlayer)player, itemstack2, cost);
                }
                this.enchantSlots.m_6596_();
                this.m_6199_(this.enchantSlots);
                level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
            }
        });
        return true;
    }

    public Pair<Optional<Integer>, Integer> getMaxLevel(Enchantment enchantment) {
        int maxPower;
        int currentPower = this.getCurrentPower();
        Pair<Optional<Integer>, Integer> maxLevelSpecial = this.getSpecialMaxLevel(enchantment, currentPower, maxPower = this.infuserType.isAdvanced() ? ((ServerConfig)EnchantingInfuser.CONFIG.server()).maximumPowerAdvanced : ((ServerConfig)EnchantingInfuser.CONFIG.server()).maximumPowerNormal);
        if (maxLevelSpecial != null) {
            return maxLevelSpecial;
        }
        int minPowerByRarity = this.getMinPowerByRarity(enchantment, maxPower);
        if (currentPower < minPowerByRarity) {
            return Pair.of(Optional.of(minPowerByRarity), (Object)0);
        }
        int levelRange = (int)Math.round((double)maxPower * ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.levelMultiplier);
        int totalLevels = enchantment.m_6586_() - enchantment.m_44702_();
        int levelPercentile = totalLevels > 0 ? levelRange / totalLevels : 0;
        for (int i = 0; i <= totalLevels; ++i) {
            int nextPower = Math.min(maxPower, minPowerByRarity + i * levelPercentile);
            if (currentPower >= nextPower) continue;
            return Pair.of(Optional.of(nextPower), (Object)(enchantment.m_44702_() + i - 1));
        }
        return Pair.of(Optional.empty(), (Object)enchantment.m_6586_());
    }

    private Pair<Optional<Integer>, Integer> getSpecialMaxLevel(Enchantment enchantment, int currentPower, int maxPower) {
        double multiplier = -1.0;
        if (enchantment.m_6589_()) {
            multiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.curseMultiplier;
        } else if (!enchantment.m_6592_()) {
            multiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.undiscoverableMultiplier;
        } else if (enchantment.m_6591_()) {
            multiplier = ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.treasureMultiplier;
        }
        if (multiplier != -1.0) {
            int nextPower = (int)Math.round((double)maxPower * multiplier);
            return currentPower < nextPower ? Pair.of(Optional.of(nextPower), (Object)0) : Pair.of(Optional.empty(), (Object)enchantment.m_6586_());
        }
        return null;
    }

    private int getMinPowerByRarity(Enchantment enchantment, int maxPower) {
        double d = maxPower;
        return (int)Math.round(d * (switch (enchantment.m_44699_()) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.commonMultiplier;
            case Enchantment.Rarity.UNCOMMON -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.uncommonMultiplier;
            case Enchantment.Rarity.RARE -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.rareMultiplier;
            case Enchantment.Rarity.VERY_RARE -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).power.veryRareMultiplier;
        }));
    }

    private int getScaledCosts() {
        int maxCost;
        double totalCosts = this.getTotalCosts();
        int n = maxCost = this.infuserType.isAdvanced() ? ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.maximumCostAdvanced : ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.maximumCostNormal;
        if (totalCosts > (double)maxCost && !(this.enchantSlots.m_8020_(0).m_41720_() instanceof BookItem)) {
            double ratio = (double)maxCost / totalCosts;
            int minCosts = this.enchantmentsToLevel.values().stream().mapToInt(Integer::intValue).sum();
            return Math.max((int)Math.round((double)this.getAllCosts() * ratio), minCosts);
        }
        return this.getAllCosts();
    }

    public void setType(InfuserBlock.InfuserType type) {
        this.infuserType = type;
    }

    private int getTotalCosts() {
        HashMap map = Maps.newHashMap();
        for (Enchantment enchantment : this.enchantmentsToLevel.keySet()) {
            if (((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.vanillaCostOnly && !ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)enchantment).m_135827_().equals("minecraft")) continue;
            Pair pair2 = Pair.of((Object)enchantment.m_44699_(), (Object)enchantment.m_6586_());
            Optional<Map.Entry> any = map.entrySet().stream().filter(e -> !((Enchantment)e.getKey()).m_44695_(enchantment)).findAny();
            if (any.isPresent()) {
                Map.Entry enchantmentData = any.get();
                Pair pair1 = (Pair)enchantmentData.getValue();
                map.put((Enchantment)enchantmentData.getKey(), this.compareEnchantmentData((Pair<Enchantment.Rarity, Integer>)pair1, (Pair<Enchantment.Rarity, Integer>)pair2));
                continue;
            }
            map.put(enchantment, pair2);
        }
        return map.values().stream().mapToInt(e -> this.getCostByRarity((Enchantment.Rarity)e.getFirst()) * (Integer)e.getSecond()).sum();
    }

    private Pair<Enchantment.Rarity, Integer> compareEnchantmentData(Pair<Enchantment.Rarity, Integer> pair1, Pair<Enchantment.Rarity, Integer> pair2) {
        int cost1 = this.getCostByRarity((Enchantment.Rarity)pair1.getFirst()) * (Integer)pair1.getSecond();
        int cost2 = this.getCostByRarity((Enchantment.Rarity)pair2.getFirst()) * (Integer)pair2.getSecond();
        return cost2 > cost1 ? pair2 : pair1;
    }

    private int getAllCosts() {
        return this.enchantmentsToLevel.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).mapToInt(entry -> this.getCostByRarity((Enchantment)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    private int getCostByRarity(Enchantment enchantment) {
        int cost = this.getCostByRarity(enchantment.m_44699_());
        if (((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.doubleUniques && (enchantment.m_6591_() || !enchantment.m_6592_()) && !enchantment.m_6589_()) {
            cost *= 2;
        }
        return cost;
    }

    private int getCostByRarity(Enchantment.Rarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.commonCost;
            case Enchantment.Rarity.UNCOMMON -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.uncommonCost;
            case Enchantment.Rarity.RARE -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.rareCost;
            case Enchantment.Rarity.VERY_RARE -> ((ServerConfig)EnchantingInfuser.CONFIG.server()).costs.veryRareCost;
        };
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
            if (pIndex == 0) {
                if (equipmentslot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(4 - equipmentslot.m_20749_())).m_6657_()) {
                    int i = 4 - equipmentslot.m_20749_();
                    if (!this.m_38903_(itemstack1, i, i + 1, false)) {
                        slot.m_142406_(pPlayer, itemstack1);
                        return ItemStack.f_41583_;
                    }
                } else if (equipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(41)).m_6657_() && !this.m_38903_(itemstack1, 41, 42, false)) {
                    slot.m_142406_(pPlayer, itemstack1);
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 5, 41, true)) {
                    slot.m_142406_(pPlayer, itemstack1);
                    return ItemStack.f_41583_;
                }
            } else if (itemstack1.m_41792_() || itemstack1.m_41720_() instanceof BookItem) {
                if (((Slot)this.f_38839_.get(0)).m_6657_()) {
                    return ItemStack.f_41583_;
                }
                ItemStack itemstack2 = itemstack1.m_41777_();
                itemstack2.m_41764_(1);
                itemstack1.m_41774_(1);
                ((Slot)this.f_38839_.get(0)).m_5852_(itemstack2);
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public int getCurrentPower() {
        return this.enchantingPower.m_6501_();
    }

    public int getCost() {
        return this.enchantingCost.m_6501_();
    }

    public boolean canEnchant(Player player) {
        int cost = this.getCost();
        return cost > 0 && (player.f_36078_ >= cost || player.m_150110_().f_35937_);
    }

    public Stream<Map.Entry<Enchantment, Integer>> getValidEnchantments() {
        return this.enchantmentsToLevel.entrySet().stream().filter(e -> (Integer)e.getValue() > 0);
    }

    public List<Map.Entry<Enchantment, Integer>> getSortedEntries() {
        return this.enchantmentsToLevel.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Enchantment)e.getKey()).m_44699_().ordinal()).thenComparing(e -> new TranslatableComponent(((Enchantment)e.getKey()).m_44704_()).getString())).collect(Collectors.toList());
    }

    public void setEnchantments(List<Enchantment> enchantments) {
        this.enchantmentsToLevel = enchantments.stream().collect(Collectors.toMap(Function.identity(), enchantment -> 0));
        this.levelAccess.m_39292_((level, blockPos) -> EnchantingInfuser.NETWORK.sendTo((Message)new S2CCompatibleEnchantsMessage(this.f_38840_, enchantments), (ServerPlayer)this.player));
    }

    public static List<Enchantment> getAvailableEnchantments(ItemStack stack, boolean allowTreasure, boolean allowUndiscoverable, boolean allowCurse) {
        ArrayList list = Lists.newArrayList();
        boolean isBook = stack.m_41720_() instanceof BookItem;
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            if (!enchantment.canApplyAtEnchantingTable(stack) && (!isBook || !enchantment.isAllowedOnBooks()) || (!enchantment.m_6592_() ? !allowUndiscoverable : (enchantment.m_6589_() ? !allowCurse : enchantment.m_6591_() && !allowTreasure))) continue;
            list.add(enchantment);
        }
        return list;
    }

    public static boolean isBlockEmpty(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60812_((BlockGetter)world, pos).m_83281_();
    }
}

