/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.room.MachineRoomConnections;
import dev.compactmods.machines.core.DimensionalPosition;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.machine.data.MachineToRoomConnections;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.CsvOutput;
import net.minecraft.world.level.ChunkPos;

public class CMMachineDataExportCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> makeMachineCsv() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"machines").requires(cs -> cs.m_6761_(2))).executes(CMMachineDataExportCommand::execAll);
    }

    private static int execAll(CommandContext<CommandSourceStack> ctx) {
        CompactMachineData machines;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.m_81377_();
        MachineRoomConnections connections = MachineToRoomConnections.get(serv);
        try {
            machines = CompactMachineData.get(serv);
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
            return -1;
        }
        File outdir = src.m_81377_().m_129971_("compactmachines");
        Path out = outdir.toPath().resolve("machines.csv").toAbsolutePath();
        try {
            Files.createDirectories(outdir.toPath(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(out, new OpenOption[0]);
            CsvOutput builder = CMMachineDataExportCommand.makeCsv(writer);
            machines.stream().forEach(room -> CMMachineDataExportCommand.writeMachine(connections, room, builder));
            writer.close();
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
            src.m_81352_((Component)TranslationUtil.message(Messages.FAILED_CMD_FILE_ERROR));
            return -1;
        }
        return 0;
    }

    @Nonnull
    private static CsvOutput makeCsv(BufferedWriter writer) throws IOException {
        return CsvOutput.m_13619_().m_13630_("id").m_13630_("dim").m_13630_("machine_x").m_13630_("machine_y").m_13630_("machine_z").m_13630_("room_x").m_13630_("room_z").m_13628_((Writer)writer);
    }

    private static void writeMachine(MachineRoomConnections connections, CompactMachineData.MachineData mach, CsvOutput builder) {
        try {
            int id = mach.getMachineId();
            DimensionalPosition loc = mach.getLocation();
            BlockPos placedAt = loc.getBlockPosition();
            ChunkPos room = connections.getConnectedRoom(id).orElse(new ChunkPos(-1, -1));
            builder.m_13624_(new Object[]{id, loc.getDimension().m_135782_().toString(), placedAt.m_123341_(), placedAt.m_123342_(), placedAt.m_123343_(), room.f_45578_, room.f_45579_});
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
        }
    }
}

