/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.room.data.CompactRoomData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class CMSummarySubcommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"summary").requires(cs -> cs.m_6761_(0))).executes(CMSummarySubcommand::exec);
    }

    private static int exec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        long numRegistered;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.m_81377_();
        ServerLevel compactLevel = serv.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactLevel != null) {
            src.m_81354_((Component)TranslationUtil.command(CMCommands.CMD_DIM_REGISTERED).m_130940_(ChatFormatting.DARK_GREEN), false);
        } else {
            src.m_81354_((Component)TranslationUtil.command(CMCommands.CMD_DIM_NOT_FOUND).m_130940_(ChatFormatting.RED), false);
        }
        try {
            CompactMachineData machineData = CompactMachineData.get(serv);
            numRegistered = machineData.stream().count();
            src.m_81354_((Component)TranslationUtil.command(CMCommands.MACHINE_REG_COUNT, numRegistered), false);
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
            throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.CMD_DIM_NOT_FOUND));
        }
        try {
            CompactRoomData roomData = CompactRoomData.get(serv);
            numRegistered = roomData.stream().count();
            src.m_81354_((Component)TranslationUtil.command(CMCommands.ROOM_REG_COUNT, numRegistered), false);
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
            throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.CMD_DIM_NOT_FOUND));
        }
        return 0;
    }
}

