/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.room.data.CompactRoomData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.CsvOutput;
import net.minecraft.world.level.chunk.LevelChunk;

public class CMTunnelDataExportCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> makeTunnelCsv() {
        RequiredArgumentBuilder chunk = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"chunkx", (ArgumentType)IntegerArgumentType.integer()).then((ArgumentBuilder)Commands.m_82129_((String)"chunkz", (ArgumentType)IntegerArgumentType.integer()))).executes(CMTunnelDataExportCommand::exec);
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tunnels").requires(cs -> cs.m_6761_(2))).executes(CMTunnelDataExportCommand::execAll)).then((ArgumentBuilder)chunk);
    }

    private static int execAll(CommandContext<CommandSourceStack> ctx) {
        CompactRoomData rooms;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer serv = src.m_81377_();
        ServerLevel compact = src.m_81377_().m_129880_(Registration.COMPACT_DIMENSION);
        try {
            rooms = CompactRoomData.get(serv);
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
            return -1;
        }
        File outdir = src.m_81377_().m_129971_("compactmachines");
        Path out = outdir.toPath().resolve("tunnels.csv").toAbsolutePath();
        try {
            Files.createDirectories(outdir.toPath(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(out, new OpenOption[0]);
            CsvOutput builder = CMTunnelDataExportCommand.makeTunnelCsvOut(writer);
            rooms.stream().forEach(roomChunk -> {
                LevelChunk chunk1 = compact.m_6325_(roomChunk.f_45578_, roomChunk.f_45579_);
                CMTunnelDataExportCommand.writeRoomTunnels(chunk1, builder);
            });
            writer.close();
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
            src.m_81352_((Component)TranslationUtil.message(Messages.FAILED_CMD_FILE_ERROR));
            return -1;
        }
        return 0;
    }

    public static int exec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.m_81375_();
        int chunkx = IntegerArgumentType.getInteger(ctx, (String)"chunkx");
        int chunkz = IntegerArgumentType.getInteger(ctx, (String)"chunkz");
        LevelChunk chunk1 = src.m_81372_().m_6325_(chunkx, chunkz);
        File outdir = src.m_81377_().m_129971_("compactmachines");
        Path out = outdir.toPath().resolve(String.format("tunnels_%s_%s.csv", chunkx, chunkz)).toAbsolutePath();
        try {
            Files.createDirectories(outdir.toPath(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(out, new OpenOption[0]);
            CsvOutput builder = CMTunnelDataExportCommand.makeTunnelCsvOut(writer);
            CMTunnelDataExportCommand.writeRoomTunnels(chunk1, builder);
            writer.close();
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error((Object)e);
            src.m_81352_((Component)TranslationUtil.message(Messages.FAILED_CMD_FILE_ERROR));
            return -1;
        }
        return 0;
    }

    @Nonnull
    private static CsvOutput makeTunnelCsvOut(BufferedWriter writer) throws IOException {
        return CsvOutput.m_13619_().m_13630_("type").m_13630_("side").m_13630_("pos_x").m_13630_("pos_y").m_13630_("pos_z").m_13630_("machine_id").m_13628_((Writer)writer);
    }

    private static void writeRoomTunnels(LevelChunk chunk1, CsvOutput builder) {
    }
}

