/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.codec.CodecExtensions;
import dev.compactmods.machines.util.LocationUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.logging.log4j.Logger;

public class DimensionalPosition
implements INBTSerializable<CompoundTag>,
IDimensionalPosition {
    private ResourceKey<Level> dimension;
    private Vec3 position;
    private Vec3 rotation;
    public static final Codec<DimensionalPosition> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).fieldOf("dim").forGetter(DimensionalPosition::getDimension), (App)CodecExtensions.VECTOR3D.fieldOf("pos").forGetter(DimensionalPosition::getPosition), (App)CodecExtensions.VECTOR3D.optionalFieldOf("rot", (Object)Vec3.f_82478_).forGetter(DimensionalPosition::getRotation)).apply((Applicative)i, DimensionalPosition::new));

    private DimensionalPosition() {
    }

    public DimensionalPosition(ResourceKey<Level> world, BlockPos positionBlock) {
        this(world, Vec3.f_82478_, Vec3.f_82478_);
        this.position = new Vec3((double)positionBlock.m_123341_(), (double)positionBlock.m_123342_(), (double)positionBlock.m_123343_());
    }

    public DimensionalPosition(ResourceKey<Level> world, Vec3 positionBlock) {
        this(world, positionBlock, Vec3.f_82478_);
        this.dimension = world;
        this.rotation = Vec3.f_82478_;
    }

    public DimensionalPosition(ResourceKey<Level> dim, Vec3 pos, Vec3 rotation) {
        this.dimension = dim;
        this.position = pos;
        this.rotation = rotation;
    }

    public static DimensionalPosition fromEntity(LivingEntity entity) {
        return new DimensionalPosition((ResourceKey<Level>)entity.f_19853_.m_46472_(), entity.m_20182_());
    }

    @Override
    public Optional<ServerLevel> level(@Nonnull MinecraftServer server) {
        return Optional.ofNullable(server.m_129880_(this.dimension));
    }

    @Override
    public Optional<BlockState> state(MinecraftServer server) {
        return this.level(server).map(sl -> sl.m_8055_(this.getBlockPosition()));
    }

    @Override
    public IDimensionalPosition relative(Direction direction) {
        return new DimensionalPosition(this.dimension, this.position.m_82520_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_()));
    }

    @Override
    public IDimensionalPosition relative(Direction direction, float amount) {
        Vec3 a = new Vec3((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
        a = a.m_82542_((double)amount, (double)amount, (double)amount);
        return new DimensionalPosition(this.dimension, this.position.m_82549_(a));
    }

    public boolean isLoaded(MinecraftServer server) {
        return this.level(server).map(w -> w.m_46749_(LocationUtil.vectorToBlockPos(this.position))).orElse(false);
    }

    public static DimensionalPosition fromNBT(CompoundTag nbt) {
        DimensionalPosition dp = new DimensionalPosition();
        dp.deserializeNBT(nbt);
        return dp;
    }

    public CompoundTag serializeNBT() {
        DataResult nbt = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this);
        return nbt.result().orElse(null);
    }

    public void deserializeNBT(CompoundTag nbt) {
        Optional dimensionalPosition = CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
        dimensionalPosition.ifPresent(dp -> {
            this.dimension = dp.dimension;
            this.position = dp.position;
            this.rotation = dp.rotation;
        });
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getRotation() {
        return this.rotation;
    }

    @Override
    public BlockPos getBlockPosition() {
        return new BlockPos(this.position.f_82479_, this.position.f_82480_, this.position.f_82481_);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionalPosition that = (DimensionalPosition)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.position.equals((Object)that.position)) {
            return false;
        }
        return this.rotation.equals((Object)that.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.position, this.rotation);
    }

    public String toString() {
        return "DimensionalPosition{d=" + this.dimension + ", p=" + this.position + ", r=" + this.rotation + "}";
    }
}

