/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.EnumMachinePlayersBreakHandling;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.room.RoomSize;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CompactMachineBlock
extends Block
implements EntityBlock {
    private final RoomSize size;

    public CompactMachineBlock(RoomSize size, BlockBehaviour.Properties props) {
        super(props);
        this.size = size;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        CompactMachineBlockEntity tile = (CompactMachineBlockEntity)worldIn.m_7702_(pos);
        float normalHardness = super.m_5880_(state, player, worldIn, pos);
        if (tile == null) {
            return normalHardness;
        }
        boolean hasPlayers = tile.hasPlayersInside();
        if (hasPlayers) {
            EnumMachinePlayersBreakHandling hand = (EnumMachinePlayersBreakHandling)((Object)ServerConfig.MACHINE_PLAYER_BREAK_HANDLING.get());
            switch (hand) {
                case UNBREAKABLE: {
                    return 0.0f;
                }
                case OWNER: {
                    Optional<UUID> ownerUUID = tile.getOwnerUUID();
                    return ownerUUID.map(uuid -> Float.valueOf(player.m_142081_() == uuid ? normalHardness : 0.0f)).orElse(Float.valueOf(normalHardness)).floatValue();
                }
                case ANYONE: {
                    return normalHardness;
                }
            }
        }
        return normalHardness;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return false;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block changedBlock, BlockPos changedPos, boolean isMoving) {
        super.m_6861_(state, world, pos, changedBlock, changedPos, isMoving);
        if (world.f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockEntity blockEntity = serverWorld.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity machine = (CompactMachineBlockEntity)blockEntity;
            ServerLevel compactWorld = serverWorld.m_142572_().m_129880_(Registration.COMPACT_DIMENSION);
            if (compactWorld == null) {
                CompactMachines.LOGGER.warn("Warning: Compact Dimension was null! Cannot fetch internal state for machine neighbor change listener.");
            }
        }
    }

    public static Block getBySize(RoomSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case RoomSize.TINY -> (Block)Registration.MACHINE_BLOCK_TINY.get();
            case RoomSize.SMALL -> (Block)Registration.MACHINE_BLOCK_SMALL.get();
            case RoomSize.NORMAL -> (Block)Registration.MACHINE_BLOCK_NORMAL.get();
            case RoomSize.LARGE -> (Block)Registration.MACHINE_BLOCK_LARGE.get();
            case RoomSize.GIANT -> (Block)Registration.MACHINE_BLOCK_GIANT.get();
            case RoomSize.MAXIMUM -> (Block)Registration.MACHINE_BLOCK_MAXIMUM.get();
        };
    }

    public static Item getItemBySize(RoomSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case RoomSize.TINY -> (Item)Registration.MACHINE_BLOCK_ITEM_TINY.get();
            case RoomSize.SMALL -> (Item)Registration.MACHINE_BLOCK_ITEM_SMALL.get();
            case RoomSize.NORMAL -> (Item)Registration.MACHINE_BLOCK_ITEM_NORMAL.get();
            case RoomSize.LARGE -> (Item)Registration.MACHINE_BLOCK_ITEM_LARGE.get();
            case RoomSize.GIANT -> (Item)Registration.MACHINE_BLOCK_ITEM_GIANT.get();
            case RoomSize.MAXIMUM -> (Item)Registration.MACHINE_BLOCK_ITEM_MAXIMUM.get();
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        Block given = CompactMachineBlock.getBySize(this.size);
        ItemStack stack = new ItemStack((ItemLike)given, 1);
        CompoundTag nbt = stack.m_41784_();
        CompactMachineBlockEntity tileEntity = (CompactMachineBlockEntity)world.m_7702_(pos);
        if (tileEntity != null && tileEntity.mapped()) {
            nbt.m_128405_("machine_id", tileEntity.machineId);
        }
        return stack;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity tile = (CompactMachineBlockEntity)blockEntity;
            if (tile.machineId != -1) {
                return;
            }
            if (!stack.m_41782_()) {
                return;
            }
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return;
            }
            if (nbt.m_128441_("machine_id")) {
                int machineID = nbt.m_128451_("machine_id");
                tile.setMachineId(machineID);
            }
            tile.doPostPlaced();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack mainItem = player.m_21205_();
        if (mainItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (mainItem.m_41720_() == Registration.PERSONAL_SHRINKING_DEVICE.get()) {
            PlayerUtil.teleportPlayerIntoMachine(level, player, pos, this.size);
        }
        return InteractionResult.SUCCESS;
    }

    public RoomSize getSize() {
        return this.size;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CompactMachineBlockEntity(pos, state);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean a) {
        CompactMachineBlockEntity entity;
        MinecraftServer server = level.m_142572_();
        if (level.f_46443_ || server == null) {
            super.m_6810_(oldState, level, pos, newState, a);
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CompactMachineBlockEntity && (entity = (CompactMachineBlockEntity)blockEntity).mapped()) {
            try {
                CompactMachineData machines = CompactMachineData.get(server);
                machines.remove(entity.machineId);
            }
            catch (MissingDimensionException e) {
                CompactMachines.LOGGER.fatal((Object)e);
            }
        }
        super.m_6810_(oldState, level, pos, newState, a);
    }
}

