/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.room.IMachineRoom;
import dev.compactmods.machines.api.room.MachineRoomConnections;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.DimensionalPosition;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.machine.data.MachineToRoomConnections;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.data.RoomTunnelData;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class CompactMachineBlockEntity
extends BlockEntity
implements ICapabilityProvider {
    public int machineId = -1;
    public long nextSpawnTick = 0L;
    protected UUID owner;
    protected String schema;
    protected boolean locked = false;
    private ChunkPos roomChunk;
    private LazyOptional<IMachineRoom> room = LazyOptional.empty();

    public CompactMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.MACHINE_TILE_ENTITY.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.ROOM) {
            return this.room.cast();
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return this.getInternalChunkPos().map(roomId -> {
                try {
                    MinecraftServer serv = sl.m_142572_();
                    RoomTunnelData tunnels = RoomTunnelData.get(serv, roomId);
                    TunnelConnectionGraph graph = tunnels.getGraph();
                    Stream<BlockPos> supportingTunnels = graph.getTunnelsSupporting(this.machineId, side, cap);
                    Optional<BlockPos> firstSupported = supportingTunnels.findFirst();
                    if (firstSupported.isEmpty()) {
                        return super.getCapability(cap, side);
                    }
                    ServerLevel compact = serv.m_129880_(Registration.COMPACT_DIMENSION);
                    if (compact == null) {
                        throw new MissingDimensionException();
                    }
                    BlockEntity patt2945$temp = compact.m_7702_(firstSupported.get());
                    if (patt2945$temp instanceof TunnelWallEntity) {
                        TunnelWallEntity tunnel = (TunnelWallEntity)patt2945$temp;
                        return tunnel.getTunnelCapability(cap, side);
                    }
                    return super.getCapability(cap, side);
                }
                catch (MissingDimensionException e) {
                    CompactMachines.LOGGER.fatal((Object)e);
                    return super.getCapability(cap, side);
                }
            }).orElse(super.getCapability(cap, side));
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    private IMachineRoom getRoom() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return this.getInternalChunkPos().map(c -> {
                ServerLevel compact = sl.m_142572_().m_129880_(Registration.COMPACT_DIMENSION);
                if (compact != null) {
                    LevelChunk inChunk = compact.m_6325_(c.f_45578_, c.f_45579_);
                    return (IMachineRoom)inChunk.getCapability(Capabilities.ROOM).orElseThrow(RuntimeException::new);
                }
                return null;
            }).orElse(null);
        }
        return null;
    }

    public void onLoad() {
        super.onLoad();
        this.room = LazyOptional.of(this::getRoom);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.machineId = nbt.m_128451_("machine_id");
        this.owner = nbt.m_128441_("owner") ? nbt.m_128342_("owner") : null;
        this.nextSpawnTick = nbt.m_128454_("spawntick");
        this.schema = nbt.m_128441_("schema") ? nbt.m_128461_("schema") : null;
        this.locked = nbt.m_128441_("locked") ? nbt.m_128471_("locked") : false;
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("machine_id", this.machineId);
        if (this.owner != null) {
            nbt.m_128362_("owner", this.owner);
        }
        nbt.m_128356_("spawntick", this.nextSpawnTick);
        if (this.schema != null) {
            nbt.m_128359_("schema", this.schema);
        }
        nbt.m_128379_("locked", this.locked);
    }

    public CompoundTag m_5995_() {
        CompoundTag base = super.m_5995_();
        base.m_128405_("machine", this.machineId);
        if (this.f_58857_ instanceof ServerLevel && this.owner != null) {
            base.m_128362_("owner", this.owner);
        }
        return base;
    }

    public Optional<ChunkPos> getInternalChunkPos() {
        if (this.f_58857_ instanceof ServerLevel) {
            if (this.roomChunk != null) {
                return Optional.of(this.roomChunk);
            }
            MinecraftServer serv = this.f_58857_.m_142572_();
            if (serv == null) {
                return Optional.empty();
            }
            MachineRoomConnections connections = MachineToRoomConnections.get(serv);
            if (connections == null) {
                return Optional.empty();
            }
            Optional<ChunkPos> chunk = connections.getConnectedRoom(this.machineId);
            chunk.ifPresent(c -> {
                this.roomChunk = c;
            });
            return chunk;
        }
        return Optional.empty();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.machineId = tag.m_128451_("machine");
        if (tag.m_128441_("players")) {
            CompoundTag compoundTag = tag.m_128469_("players");
        }
        if (tag.m_128441_("owner")) {
            this.owner = tag.m_128342_("owner");
        }
    }

    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setMachineId(int id) {
        this.machineId = id;
        this.room.invalidate();
        this.roomChunk = null;
        this.m_6596_();
    }

    public boolean hasPlayersInside() {
        return false;
    }

    public void doPostPlaced() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        MinecraftServer serv = this.f_58857_.m_142572_();
        if (serv == null) {
            return;
        }
        DimensionalPosition dp = new DimensionalPosition((ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_);
        try {
            CompactMachineData extern = CompactMachineData.get(serv);
            extern.setMachineLocation(this.machineId, dp);
            this.m_6596_();
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
        }
    }

    public boolean mapped() {
        return this.getInternalChunkPos().isPresent();
    }

    public Optional<DimensionalPosition> getSpawn() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            MinecraftServer serv = serverWorld.m_142572_();
            MachineRoomConnections connections = MachineToRoomConnections.get(serv);
            if (connections == null) {
                return Optional.empty();
            }
            Optional<ChunkPos> connectedRoom = connections.getConnectedRoom(this.machineId);
            if (connectedRoom.isEmpty()) {
                return Optional.empty();
            }
            try {
                CompactRoomData roomData = CompactRoomData.get(serv);
                ChunkPos chunk = connectedRoom.get();
                return Optional.ofNullable(roomData.getSpawn(chunk));
            }
            catch (MissingDimensionException e) {
                CompactMachines.LOGGER.fatal((Object)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

