/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import com.mojang.authlib.GameProfile;
import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineBlock;
import dev.compactmods.machines.room.RoomSize;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class CompactMachineItem
extends BlockItem {
    public CompactMachineItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public static Optional<Integer> getMachineId(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Optional.empty();
        }
        CompoundTag machineData = stack.m_41784_();
        if (machineData.m_128441_("machine_id")) {
            int c = machineData.m_128451_("machine_id");
            return c > -1 ? Optional.of(c) : Optional.empty();
        }
        return Optional.empty();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return;
            }
            CompactMachineItem.getMachineId(stack).ifPresent(id -> tooltip.add((Component)TranslationUtil.tooltip(Tooltips.Machines.ID, id)));
            if (nbt.m_128441_("owner")) {
                UUID owner = nbt.m_128342_("owner");
                Optional<GameProfile> playerProfile = PlayerUtil.getProfileByUUID((LevelAccessor)worldIn, owner);
                MutableComponent player = playerProfile.map(p -> new TextComponent(p.getName())).orElse((MutableComponent)TranslationUtil.tooltip(Tooltips.UNKNOWN_PLAYER_NAME));
                MutableComponent ownerText = TranslationUtil.tooltip(Tooltips.Machines.OWNER).m_7220_((Component)player);
                tooltip.add((Component)ownerText);
            }
        }
        if (Screen.m_96638_()) {
            Block b = Block.m_49814_((Item)stack.m_41720_());
            if (b instanceof CompactMachineBlock) {
                CompactMachineBlock cmb = (CompactMachineBlock)b;
                RoomSize size = cmb.getSize();
                int internalSize = size.getInternalSize();
                MutableComponent text = TranslationUtil.tooltip(Tooltips.Machines.SIZE, internalSize).m_130940_(ChatFormatting.YELLOW);
                tooltip.add((Component)text);
            }
        } else {
            MutableComponent text = TranslationUtil.tooltip(Tooltips.HINT_HOLD_SHIFT).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC);
            tooltip.add((Component)text);
        }
    }
}

