/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.room.MachineRoomConnections;
import dev.compactmods.machines.core.DimensionalPosition;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.machine.data.MachineToRoomConnections;
import dev.compactmods.machines.tunnel.data.RoomTunnelData;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class Machines {
    public static boolean createAndLink(MinecraftServer server, Level level, BlockPos machinePos, CompactMachineBlockEntity tile, ChunkPos room) {
        try {
            int nextId = Machines.createNew(server, level, machinePos);
            tile.setMachineId(nextId);
            return Machines.link(server, nextId, room);
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal("Critical error while trying to create a new machine and link it to a new room.", (Throwable)e);
            return false;
        }
    }

    public static int createNew(MinecraftServer server, Level level, BlockPos machinePos) throws MissingDimensionException {
        CompactMachineData machines = CompactMachineData.get(server);
        MachineRoomConnections connections = MachineToRoomConnections.get(server);
        if (connections == null) {
            CompactMachines.LOGGER.error("Could not load world saved data while creating new machine and room.");
            throw new MissingDimensionException();
        }
        int nextId = machines.getNextMachineId();
        machines.setMachineLocation(nextId, new DimensionalPosition((ResourceKey<Level>)level.m_46472_(), machinePos));
        connections.registerMachine(nextId);
        return nextId;
    }

    public static boolean link(MinecraftServer server, int machine, ChunkPos room) {
        MachineRoomConnections connections = MachineToRoomConnections.get(server);
        if (connections == null) {
            CompactMachines.LOGGER.error("Could not load world saved data while creating new machine and room.");
            return false;
        }
        connections.connectMachineToRoom(machine, room);
        return true;
    }

    public static boolean destroy(MinecraftServer server, int machine) {
        MachineRoomConnections connections = MachineToRoomConnections.get(server);
        if (connections == null) {
            CompactMachines.LOGGER.error("Could not load world saved data while creating new machine and room.");
            return false;
        }
        connections.getConnectedRoom(machine).ifPresent(room -> {
            try {
                RoomTunnelData tunnels = RoomTunnelData.get(server, room);
                TunnelConnectionGraph tunnelGraph = tunnels.getGraph();
                tunnelGraph.deleteMachine(machine);
                tunnels.m_77762_();
            }
            catch (MissingDimensionException e) {
                e.printStackTrace();
            }
        });
        connections.disconnect(machine);
        return true;
    }
}

