/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.data;

import com.mojang.serialization.DynamicOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.room.MachineRoomConnections;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.graph.CompactMachineConnectionGraph;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.Logger;

public class MachineToRoomConnections
extends SavedData
implements MachineRoomConnections {
    public static final String DATA_NAME = "compactmachines_connections";
    private CompactMachineConnectionGraph graph = new CompactMachineConnectionGraph();

    public static MachineRoomConnections get(MinecraftServer server) {
        ServerLevel compactWorld = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.error("No compact dimension found. Report this.");
            return null;
        }
        DimensionDataStorage sd = compactWorld.m_8895_();
        return (MachineRoomConnections)sd.m_164861_(MachineToRoomConnections::fromNbt, MachineToRoomConnections::new, DATA_NAME);
    }

    static MachineToRoomConnections fromNbt(CompoundTag nbt) {
        MachineToRoomConnections c = new MachineToRoomConnections();
        if (nbt.m_128441_("graph")) {
            CompoundTag graphNbt = nbt.m_128469_("graph");
            CompactMachineConnectionGraph.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)graphNbt).resultOrPartial(arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0)).ifPresent(g -> {
                c.graph = g;
            });
        }
        return c;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        CompactMachineConnectionGraph.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.graph).resultOrPartial(arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0)).ifPresent(gNbt -> nbt.m_128365_("graph", gNbt));
        return nbt;
    }

    @Override
    @Nonnull
    public Optional<ChunkPos> getConnectedRoom(int machineId) {
        return this.graph.getConnectedRoom(machineId);
    }

    @Override
    @Nonnull
    @Deprecated(since="1.7.0")
    public Collection<Integer> getMachinesFor(ChunkPos chunkPos) {
        try {
            return this.graph.getMachinesFor(chunkPos);
        }
        catch (NonexistentRoomException e) {
            CompactMachines.LOGGER.error("Tried to get machine info for nonexistent room: " + chunkPos, (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public void registerMachine(int machine) {
        this.graph.addMachine(machine);
        this.m_77762_();
    }

    @Override
    public void registerRoom(ChunkPos roomChunk) {
        this.graph.addRoom(roomChunk);
        this.m_77762_();
    }

    @Override
    public void unregisterRoom(ChunkPos roomChunk) {
        this.graph.removeRoom(roomChunk);
        this.m_77762_();
    }

    @Override
    public void connectMachineToRoom(int machine, ChunkPos room) {
        this.graph.connectMachineToRoom(machine, room);
        this.m_77762_();
    }

    @Override
    public void disconnect(int machine) {
        this.graph.disconnectAndUnregister(machine);
        this.m_77762_();
    }
}

