/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.network;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.room.MachineRoomConnections;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.machine.data.MachineToRoomConnections;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public class CMPacketTargets {
    public static final PacketDistributor<LevelChunk> TRACKING_ROOM = new PacketDistributor(CMPacketTargets::trackingRoom, NetworkDirection.PLAY_TO_CLIENT);

    private static Consumer<Packet<?>> trackingRoom(PacketDistributor<LevelChunk> dist, Supplier<LevelChunk> supplier) {
        LevelChunk roomChunk = supplier.get();
        Level level = roomChunk.m_62953_();
        HashMap trackingPlayersGlobal = new HashMap();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            MinecraftServer server = serverWorld.m_142572_();
            MachineRoomConnections connections = MachineToRoomConnections.get(server);
            try {
                CompactMachineData machines = CompactMachineData.get(server);
                Collection<Integer> linked = connections.getMachinesFor(roomChunk.m_7697_());
                for (int machine : linked) {
                    machines.getMachineLocation(machine).ifPresent(loc -> {
                        Optional<ServerLevel> machineWorld = loc.level(server);
                        BlockPos machineWorldLocation = loc.getBlockPosition();
                        ChunkPos machineWorldChunk = new ChunkPos(machineWorldLocation);
                        machineWorld.ifPresent(mw -> mw.m_7726_().f_8325_.m_183262_(machineWorldChunk, false).forEach(player -> {
                            if (!trackingPlayersGlobal.containsKey(player.m_142081_())) {
                                trackingPlayersGlobal.put(player.m_142081_(), player.f_8906_);
                            }
                        }));
                    });
                }
            }
            catch (MissingDimensionException e) {
                CompactMachines.LOGGER.fatal((Object)e);
            }
        }
        return pack -> trackingPlayersGlobal.values().forEach(conn -> conn.m_141995_(pack));
    }
}

