/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.network;

import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.tunnel.client.ClientTunnelHandler;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TunnelAddedPacket {
    @Nonnull
    private final BlockPos position;
    @Nonnull
    private final TunnelDefinition type;

    public TunnelAddedPacket(@Nonnull BlockPos tunnelPos, @Nonnull TunnelDefinition tunnelType) {
        this.position = tunnelPos;
        this.type = tunnelType;
    }

    public TunnelAddedPacket(FriendlyByteBuf buf) {
        this.position = buf.m_130135_();
        this.type = Tunnels.getDefinition(buf.m_130281_());
    }

    public static void handle(TunnelAddedPacket message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientTunnelHandler.setTunnel(message.position, message.type));
        ctx.setPacketHandled(true);
    }

    public static void encode(@Nonnull TunnelAddedPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.position);
        buf.m_130085_(Objects.requireNonNull(pkt.type.getRegistryName()));
    }
}

