/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.api.room.MachineRoomConnections;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.machine.data.MachineToRoomConnections;
import dev.compactmods.machines.room.RoomSize;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.data.RoomTunnelData;
import dev.compactmods.machines.util.CompactStructureGenerator;
import dev.compactmods.machines.util.MathUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.OperationNotSupportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;

public class Rooms {
    public static ChunkPos createNew(MinecraftServer serv, RoomSize size, UUID owner) throws MissingDimensionException {
        CompactRoomData rooms = CompactRoomData.get(serv);
        MachineRoomConnections connections = MachineToRoomConnections.get(serv);
        ServerLevel compactWorld = serv.m_129880_(Registration.COMPACT_DIMENSION);
        if (connections == null) {
            throw new MissingDimensionException("Could not load world saved data while creating new room.");
        }
        if (compactWorld == null) {
            throw new MissingDimensionException();
        }
        int nextPosition = rooms.getNextSpiralPosition();
        Vec3i location = MathUtil.getRegionPositionByIndex(nextPosition);
        int centerY = (Integer)ServerConfig.MACHINE_FLOOR_Y.get() + size.getInternalSize() / 2;
        BlockPos newCenter = MathUtil.getCenterWithY(location, centerY);
        CompactStructureGenerator.generateCompactStructure((LevelAccessor)compactWorld, size, newCenter);
        ChunkPos machineChunk = new ChunkPos(newCenter);
        connections.registerRoom(machineChunk);
        try {
            rooms.createNew().owner(owner).size(size).chunk(machineChunk).register();
        }
        catch (OperationNotSupportedException e) {
            CompactMachines.LOGGER.warn((Object)e);
        }
        return machineChunk;
    }

    public static boolean destroy(MinecraftServer server, ChunkPos room) throws MissingDimensionException, NonexistentRoomException {
        CompactRoomData roomData = CompactRoomData.get(server);
        if (!roomData.isRegistered(room)) {
            throw new NonexistentRoomException(room);
        }
        ServerLevel level = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (level == null) {
            throw new MissingDimensionException();
        }
        AABB roomBounds = roomData.getBounds(room);
        AABB innerBounds = roomBounds.m_82406_(1.0);
        Set states = level.m_45556_(innerBounds).collect(Collectors.toSet());
        Optional<BlockState> nonAir = states.stream().filter(state -> !state.m_60795_()).findAny();
        if (nonAir.isPresent()) {
            CompactMachines.LOGGER.error("Refusing to delete room at {}; non-air blocks exist inside the room. First match: {}", (Object)room, (Object)nonAir.get());
            return false;
        }
        File tunnels = RoomTunnelData.getFile(server, room);
        String filename = RoomTunnelData.getDataFilename(room);
        if (!tunnels.delete()) {
            CompactMachines.LOGGER.warn("Could not delete tunnel data for room {}; clearing the connection graph as an alternative.", (Object)room);
            CompactMachines.LOGGER.warn("Data file to delete: {}", (Object)filename);
            RoomTunnelData td = RoomTunnelData.get(server, room);
            td.getGraph().clear();
            td.m_77762_();
        } else {
            Map compactDataCache = level.m_8895_().f_78144_;
            compactDataCache.remove(filename);
        }
        BlockPos.m_121921_((AABB)roomBounds.m_82400_(1.0)).forEach(p -> level.m_7731_(p, Blocks.f_50016_.m_49966_(), 3));
        roomData.remove(room);
        MachineRoomConnections conns = MachineToRoomConnections.get(server);
        CompactMachineData d = CompactMachineData.get(server);
        Collection<Integer> connected = conns.getMachinesFor(room);
        for (int mid : connected) {
            LazyOptional<IDimensionalPosition> location = d.getMachineLocation(mid);
            location.ifPresent(p -> {
                BlockPos pos = p.getBlockPosition();
                ServerLevel l = p.level(server).orElseThrow();
                BlockEntity patt5101$temp = l.m_7702_(pos);
                if (patt5101$temp instanceof TunnelWallEntity) {
                    TunnelWallEntity tunn = (TunnelWallEntity)patt5101$temp;
                    tunn.disconnect();
                }
            });
        }
        conns.unregisterRoom(room);
        return true;
    }

    public static Stream<Integer> getConnectedMachines(MinecraftServer server, ChunkPos room) {
        try {
            MachineRoomConnections conns = MachineToRoomConnections.get(server);
            CompactMachineData d = CompactMachineData.get(server);
            return conns.getMachinesFor(room).stream();
        }
        catch (MissingDimensionException e) {
            return Stream.empty();
        }
    }
}

