/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.capability;

import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.room.capability.PlayerRoomHistoryCapProvider;
import dev.compactmods.machines.room.capability.RoomChunkDataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compactmachines", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoomCapEventHandler {
    @SubscribeEvent
    static void onCapPlayerAttach(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (!(object instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        event.addCapability(new ResourceLocation("compactmachines", "room_history"), (ICapabilityProvider)new PlayerRoomHistoryCapProvider(player));
    }

    @SubscribeEvent
    static void onCapChunkAttach(AttachCapabilitiesEvent<LevelChunk> evt) {
        boolean isRoom;
        LevelChunk chunk = (LevelChunk)evt.getObject();
        if (chunk.m_62953_().f_46443_) {
            return;
        }
        if (chunk.m_62953_().m_46472_() != Registration.COMPACT_DIMENSION) {
            return;
        }
        boolean bl = isRoom = chunk.m_7697_().f_45578_ % 64 == 0 && chunk.m_7697_().f_45579_ % 64 == 0;
        if (isRoom) {
            evt.addCapability(new ResourceLocation("compactmachines", "room_info"), (ICapabilityProvider)new RoomChunkDataProvider(chunk));
        }
    }
}

