/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.api.room.IMachineRoom;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.TunnelPosition;
import dev.compactmods.machines.api.tunnels.capability.CapabilityTunnel;
import dev.compactmods.machines.api.tunnels.lifecycle.InstancedTunnel;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelInstance;
import dev.compactmods.machines.api.tunnels.lifecycle.TunnelTeardownHandler;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.machine.data.CompactMachineData;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class TunnelWallEntity
extends BlockEntity {
    private int connectedMachine;
    private TunnelDefinition tunnelType;
    private LazyOptional<IMachineRoom> ROOM = LazyOptional.empty();
    @Nullable
    private TunnelInstance tunnel;

    public TunnelWallEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Tunnels.TUNNEL_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        block8: {
            super.m_142466_(nbt);
            try {
                if (nbt.m_128441_("machine")) {
                    this.connectedMachine = nbt.m_128451_("machine");
                }
                if (!nbt.m_128441_("tunnel_type")) break block8;
                ResourceLocation type = new ResourceLocation(nbt.m_128461_("tunnel_type"));
                this.tunnelType = Tunnels.getDefinition(type);
                try {
                    Object object = this.tunnelType;
                    if (object instanceof InstancedTunnel) {
                        InstancedTunnel it = (InstancedTunnel)object;
                        this.tunnel = it.newInstance(this.f_58858_, this.getTunnelSide());
                    }
                    if ((object = this.tunnel) instanceof INBTSerializable) {
                        INBTSerializable persist = (INBTSerializable)object;
                        if (nbt.m_128441_("tunnel_data")) {
                            Tag data = nbt.m_128423_("tunnel_data");
                            persist.deserializeNBT(data);
                        }
                    }
                }
                catch (Exception ex) {
                    CompactMachines.LOGGER.error("Error loading tunnel persistent data at {}; this is likely a cross-mod issue!", (Object)this.f_58858_, (Object)ex);
                }
            }
            catch (Exception e) {
                this.tunnelType = (TunnelDefinition)Tunnels.UNKNOWN.get();
                this.connectedMachine = -1;
            }
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        if (this.tunnelType != null) {
            compound.m_128359_("tunnel_type", this.tunnelType.getRegistryName().toString());
        } else {
            compound.m_128359_("tunnel_type", Tunnels.UNKNOWN.getId().toString());
        }
        compound.m_128405_("machine", this.connectedMachine);
        TunnelInstance tunnelInstance = this.tunnel;
        if (tunnelInstance instanceof INBTSerializable) {
            INBTSerializable persist = (INBTSerializable)tunnelInstance;
            Tag data = persist.serializeNBT();
            compound.m_128365_("tunnel_data", data);
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128359_("tunnel_type", this.tunnelType.getRegistryName().toString());
        nbt.m_128405_("machine", this.connectedMachine);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("tunnel_type")) {
            ResourceLocation id = new ResourceLocation(tag.m_128461_("tunnel_type"));
            this.tunnelType = Tunnels.getDefinition(id);
        }
        if (tag.m_128441_("machine")) {
            this.connectedMachine = tag.m_128451_("machine");
        }
        this.m_6596_();
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            LevelChunk chunk = this.f_58857_.m_46745_(this.f_58858_);
            this.ROOM = chunk.getCapability(Capabilities.ROOM);
            if (this.tunnelType != null && this.tunnelType.equals(Tunnels.UNKNOWN.get())) {
                CompactMachines.LOGGER.warn("Removing unknown tunnel type at {}", (Object)this.f_58858_.m_123344_());
                sl.m_7731_(this.f_58858_, ((Block)Registration.BLOCK_SOLID_WALL.get()).m_49966_(), 3);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getTunnelCapability(@Nonnull Capability<T> cap, @Nullable Direction outerSide) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return LazyOptional.empty();
        }
        if (outerSide != null && outerSide != this.getConnectedSide()) {
            return LazyOptional.empty();
        }
        TunnelDefinition tunnelDefinition = this.tunnelType;
        if (tunnelDefinition instanceof CapabilityTunnel) {
            CapabilityTunnel c = (CapabilityTunnel)((Object)tunnelDefinition);
            return c.getCapability(cap, this.tunnel);
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return super.getCapability(cap, side);
        }
        if (side != null && side != this.getTunnelSide()) {
            return super.getCapability(cap, side);
        }
        TunnelDefinition tunnelDefinition = this.tunnelType;
        if (tunnelDefinition instanceof CapabilityTunnel) {
            CapabilityTunnel c = (CapabilityTunnel)((Object)tunnelDefinition);
            return c.getCapability(cap, this.tunnel);
        }
        return super.getCapability(cap, side);
    }

    public IDimensionalPosition getConnectedPosition() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return null;
        }
        MinecraftServer server = this.f_58857_.m_142572_();
        if (server == null) {
            return null;
        }
        try {
            CompactMachineData machines = CompactMachineData.get(server);
            return machines.getMachineLocation(this.connectedMachine).map(dp -> dp.relative(this.getConnectedSide())).orElse(null);
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
            return null;
        }
    }

    public Direction getTunnelSide() {
        BlockState state = this.m_58900_();
        return (Direction)state.m_61143_((Property)TunnelWallBlock.TUNNEL_SIDE);
    }

    public Direction getConnectedSide() {
        BlockState blockState = this.m_58900_();
        return (Direction)blockState.m_61143_((Property)TunnelWallBlock.CONNECTED_SIDE);
    }

    public void setTunnelType(TunnelDefinition type) {
        Level level;
        if (type == this.tunnelType) {
            return;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !((level = this.f_58857_) instanceof ServerLevel)) {
            this.tunnelType = type;
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        TunnelPosition p = new TunnelPosition(sl, this.f_58858_, this.getTunnelSide());
        TunnelDefinition tunnelDefinition = this.tunnelType;
        if (tunnelDefinition instanceof TunnelTeardownHandler) {
            TunnelTeardownHandler teardown = (TunnelTeardownHandler)((Object)tunnelDefinition);
            teardown.onRemoved(p, this.tunnel);
        }
        this.tunnelType = type;
        if (type instanceof InstancedTunnel) {
            InstancedTunnel it = (InstancedTunnel)((Object)type);
            this.tunnel = it.newInstance(p.pos(), p.side());
        }
        this.m_6596_();
    }

    public TunnelDefinition getTunnelType() {
        return this.tunnelType;
    }

    public void setConnectedTo(int machine) {
        CompactMachineData data;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        try {
            data = CompactMachineData.get(this.f_58857_.m_142572_());
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
            return;
        }
        data.getMachineLocation(machine).ifPresent(p -> {
            this.connectedMachine = machine;
        });
    }

    @Nullable
    public TunnelInstance getTunnel() {
        return this.tunnel;
    }

    public void setInstance(TunnelInstance newTunn) {
        this.tunnel = newTunn;
        this.m_6596_();
    }

    public int getMachine() {
        return this.connectedMachine;
    }

    public void disconnect() {
        CompactMachineData data;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.connectedMachine = -1;
            return;
        }
        try {
            data = CompactMachineData.get(this.f_58857_.m_142572_());
        }
        catch (MissingDimensionException e) {
            CompactMachines.LOGGER.fatal((Object)e);
            return;
        }
        data.remove(this.connectedMachine);
        this.connectedMachine = -1;
        this.m_6596_();
    }
}

