/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel.data;

import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class RoomTunnelData
extends SavedData {
    private final TunnelConnectionGraph graph = new TunnelConnectionGraph();

    public static String getDataFilename(ChunkPos room) {
        return "tunnels_" + room.f_45578_ + "_" + room.f_45579_;
    }

    public static RoomTunnelData get(MinecraftServer server, ChunkPos room) throws MissingDimensionException {
        ServerLevel level = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (level == null) {
            throw new MissingDimensionException();
        }
        DimensionDataStorage storage = level.m_8895_();
        return (RoomTunnelData)storage.m_164861_(RoomTunnelData::fromDisk, RoomTunnelData::new, RoomTunnelData.getDataFilename(room));
    }

    public static File getFile(MinecraftServer server, ChunkPos room) throws MissingDimensionException {
        ServerLevel level = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (level == null) {
            throw new MissingDimensionException();
        }
        DimensionDataStorage storage = level.m_8895_();
        return storage.m_78156_(RoomTunnelData.getDataFilename(room));
    }

    private static RoomTunnelData fromDisk(CompoundTag tag) {
        RoomTunnelData instance = new RoomTunnelData();
        if (tag.m_128441_("graph")) {
            CompoundTag g = tag.m_128469_("graph");
            instance.graph.deserializeNBT(g);
        }
        return instance;
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag gData = this.graph.serializeNBT();
        tag.m_128365_("graph", (Tag)gData);
        return tag;
    }

    @Nonnull
    public TunnelConnectionGraph getGraph() {
        return this.graph;
    }
}

